package com.xdja.im.lib.audio.player;

public interface AudioListener {

    /**
     * 开始播放回调
     * @param filePath 正在播放的路径
     * @param args 传入的可变参数
     */
    void playingCallback(String filePath, Object...args);

    /**
     * 停止播放回调方法
     * @param filePath 正在播放的路径
     * @param args 传入的可变参数
     */
    void playingStopCallback(String filePath, Object...args);

    /**
     * 播放出错的回调方法
     * @param filePath 正在播放的路径
     * @param args 传入的可变参数
     */
    void playingErrorCallback(String filePath, Object...args);

    /**
     * 播放完成的回调方法
     * @param filePath 正在播放的路径
     * @param args 传入的可变参数
     */
    void playingCompletionCallback(String filePath, Object...args);
}
