package com.xdja.im.lib.camera;

import android.app.Activity;
import android.content.Intent;
import android.os.Environment;
import android.support.v4.app.Fragment;

import com.xdja.im.common.imageloader.DefaultImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.lib.camera.ui.activity.TakePhotoActivity;

/**
 * @Package: com.xdja.im.lib.camera
 * @Author: xdjaxa
 * @Creation: 2017-04-25 20:55
 * @Version V1.0
 * @Description:相机管理类
 */
public class CameraManager {

    private ImageLoader mImageLoader;
    private CameraConfig cameraConfig;

     private static final String CACHE_PATH = "camera";

    private static class CameraManagerInstance {
        private static final CameraManager mInstance = new CameraManager();
    }

    private CameraManager() {
    }

    public static CameraManager getInstance() {
        return CameraManagerInstance.mInstance;
    }

    /**
     * 打开相机拍照,从Fragment启动
     *
     * @param fragment    Fragment实例
     * @param requestCode 请求码
     */
    public void startTakePhoto(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), TakePhotoActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    /**
     * 打开相机拍照，从Activity启动
     *
     * @param activity    Activity实例
     * @param requestCode 请求码
     */
    public void startTakePhoto(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(activity, TakePhotoActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    /**
     * 获取图片加载器
     *
     * @return
     */
    public ImageLoader getImageLoader() {
        if (mImageLoader == null) {
            mImageLoader = new DefaultImageLoader();
        }
        return mImageLoader;
    }

    /**
     * 设置图片加载器
     *
     * @param imageLoader 图片加载器
     */
    public void setImageLoader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    /**
     * 获取图片加载配置信息
     *
     * @return 配置信息
     */
    public CameraConfig getConfig() {
        if (cameraConfig == null) {
            cameraConfig = new CameraConfig();
            cameraConfig.setCachePath(Environment.getExternalStorageDirectory()
                    + "/" + CACHE_PATH);
        }
        return cameraConfig;
    }
}
