package com.xdja.im.lib.camera.ui.view;

import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;

import com.bumptech.glide.Glide;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.camera.bean.PhotoItem;
import com.xdja.im.lib.camera.ui.presenter.TakePhotoPresenter;
import com.xdja.im.lib.camera.ui.view.vu.TakePhotoVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.PhotoView;

import java.io.File;

/**
 * @Package: com.xdja.im.lib.camera.ui.view
 * @Author: xdjaxa
 * @Creation: 2017-04-26 15:26
 * @Version V1.0
 * @Description:
 */
public class ViewTakePhoto extends ImActivitySuperView<TakePhotoPresenter>
        implements TakePhotoVu {

    /**
     * 拍照预览控件
     */
    private PhotoView mPhotoView;

    /**
     * 原图选择按钮
     */
    private CheckBox mOriginChx;

    /**
     * 发送按钮
     */
    private Button mSendBtn;

    /**
     * 是否选中原图
     */
    private boolean bOrigin;

    private PhotoItem photoItem;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_take_photo;
    }

    @Override
    protected int getToolbarType() {
        return ImActivitySuperView.ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mPhotoView = (PhotoView) findViewById(R.id.img_preview);
        mOriginChx = (CheckBox) findViewById(R.id.btn_original_pic_select);
        mSendBtn = (Button) findViewById(R.id.btn_send);
        //图片大小信息

        mOriginChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                bOrigin = isChecked;
            }
        });
        mSendBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (photoItem != null) {
                    getPresenter().sendPhoto(photoItem, bOrigin);
                }
            }
        });

        mPhotoView.enable();
        mPhotoView.setAdjustViewBounds(true);
        getView().setVisibility(View.GONE);
    }


    @Override
    public void loadImage(File file) {

        getView().setVisibility(View.VISIBLE);

        if (!file.exists()) {
            LogUtil.e("Take photo, but file is not exist.");
            return;
        }

        photoItem = new PhotoItem();
        photoItem.setFileName(file.getName());
        photoItem.setFilePath(file.getPath());
        photoItem.setFileSize(file.length());

        String fileSizeContent = FileSizeUtils.getAutoFileOrFilesSize(file.getPath());
        mOriginChx.setText(String.format(getStringRes(R.string.im_uikit_original_image),
                fileSizeContent));
        Glide.with(getActivity())
                .load(file)
                .error(R.mipmap.im_uikit_pic_default)
                .into(mPhotoView);
    }
}
