package com.xdja.im.common.database.builder;

/**
 * @Package: com.xdja.im.common.database.builder
 * @Author: xdjaxa
 * @Creation: 2017-05-22 15:37
 * @Version V1.0
 * @Description:
 */
public class SettingEntityBuilder {

    public static final String TABLE_NAME = "t_setting";


    public static final String ID = "_id";                      // 数据库id
    public static final String ACCOUNT = "account";             // 登录用户
    public static final String REMIND_TYPE = "remindMode";      // 提醒方式
    public static final String TYPE_VOICE = "remindVoice";      // 响铃方式
    public static final String TYPE_VIBRATE = "remindVibrate";  // 震动方式
    public static final String RECEIVE_MODE = "receiverMode";   // 听筒模式
    public static final String DISTURB_MODE = "disturbMode";    // 勿扰模式
    public static final String DISTURB_START = "disturbStart";  // 勿扰开始时间
    public static final String DISTURB_END = "disturbEnd";      // 勿扰结束时间

    private static final String[] ALL_COLUMNS = {ID, ACCOUNT, REMIND_TYPE, TYPE_VOICE, TYPE_VIBRATE,
            RECEIVE_MODE, DISTURB_MODE, DISTURB_START, DISTURB_END};

    public static final String SQL_CREATE_TABLE_SETTING_ENTRY =
            "CREATE TABLE " + TABLE_NAME + " ("
                    + ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
                    + ACCOUNT + " TEXT UNIQUE NOT NULL,"
                    + REMIND_TYPE + " INTEGER DEFAULT 1,"
                    + TYPE_VOICE + " INTEGER DEFAULT 1,"
                    + TYPE_VIBRATE + " INTEGER DEFAULT 1,"
                    + RECEIVE_MODE + " INTEGER DEFAULT 0,"
                    + DISTURB_MODE + " INTEGER DEFAULT 0,"
                    + DISTURB_START + " INTEGER DEFAULT 0,"
                    + DISTURB_END + " INTEGER DEFAULT 0)";

    /**
     * 插入
     * INSERT OR IGNORE INTO session_entry (...) VALUES(...);
     *
     * @return sql
     */
    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR IGNORE INTO  ",
                TABLE_NAME, ALL_COLUMNS);
    }

    public static String querySql() {
        StringBuilder builder = new StringBuilder("SELECT * FROM ");
        builder.append(TABLE_NAME);
        return builder.toString();
    }

    public static String querySql(String account) {
        StringBuilder builder = new StringBuilder("SELECT * FROM ");
        builder.append(TABLE_NAME);
        builder.append(" WHERE ").append(TABLE_NAME).append(".").
                append(ACCOUNT).append(" = '").append(account).append("'");
        return builder.toString();
    }

    public static String delSql(String account) {
        return SqlBuilder.deleteSql(SettingEntityBuilder.TABLE_NAME,
                SettingEntityBuilder.ACCOUNT,
                account);
    }
}
