package com.xdja.im.common.imageloader;

import android.app.Activity;
import android.widget.ImageView;

import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestManager;
import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.common.imageloader
 * @Author: xdjaxa
 * @Creation: 2017-04-25 15:40
 * @Version V1.0
 * @Description: 默认图片加载器
 */
public class GlideImageLoader implements ImageLoader {

    @Override
    public void loadImage(Activity activity, ImageView target, String path, ImageView.ScaleType type, int width, int height) {

        RequestManager requestManager = Glide.with(activity);
        DrawableRequestBuilder builder = requestManager.load(path);
        if (type == ImageView.ScaleType.CENTER_CROP) {
            builder.centerCrop();
        }
        if (width >0 && height >0) {
            builder.override(width, height);
        }
        builder.error(R.mipmap.im_uikit_pic_default)
                .priority(Priority.HIGH)
                .dontTransform()
                .into(target);
    }

    @Override
    public void clearMemoryCache(Activity activity) {
        Glide.get(activity).clearMemory();
    }
}
