package com.xdja.im.common.imageloader;

import android.app.Activity;
import android.widget.ImageView;

import java.io.Serializable;

/**
 * @Package: com.xdja.im.common.imageloader
 * @Author: xdjaxa
 * @Creation: 2017-04-26 16:31
 * @Version V1.0
 * @Description:ImageLoader接口类，如果外部实现该接口，则调用外部接口加载图片； 如果外部未实现，则使用默认的加载器{@link DefaultImageLoader}
 */
public interface ImageLoader extends Serializable {
    /**
     * 加载本地图片
     *
     * @param activity
     * @param target   目标显示控件
     * @param path     本地图片地址
     * @param type     图片类型
     * @param width    图片宽度
     * @param height   图片高度
     */
    void loadImage(Activity activity, ImageView target, String path, ImageView.ScaleType type, int width, int height);

    /**
     * 清除缓存
     */
    void clearMemoryCache(Activity activity);
}
