package com.xdja.im.common.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.MimeUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.File;

/**
 * @Package: com.xdja.im.lib.camera.utils
 * @Author: xdjaxa
 * @Creation: 2017-07-10 11:20
 * @Version V1.0
 * @Description:
 */
public class SystemHelper {

    /**
     * 调用系统应用打开文件
     *
     * @param filePath
     * @return
     */
    public static void openFile(Activity activity, String filePath) {
        String suffix = filePath.substring(filePath.lastIndexOf(".") + 1).toLowerCase();
        if (TextUtils.isEmpty(filePath)) {
            CommonTool.showToast(R.string.im_uikit_file_not_exist);
            return;
        }

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        //获取对应的mimetype
        //添加转换为小写。
        String type;
        if (TextUtils.isEmpty(suffix)) {
            type = "*/*";
        } else {
            type = MimeUtils.getMimeTypeWithExtension(suffix.toLowerCase());
            if (TextUtils.isEmpty(type)) {
                type = "*/*";
            }
        }

        if (!TextUtils.isEmpty(type) && !"*/*".equals(type)) {
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    Uri uri = FileProvider.getUriForFile(activity,
                            activity.getPackageName() + ".provider",
                            new File(filePath));
                    intent.setDataAndType(uri, type);
                    intent.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION
                            | Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                } else {
                    intent.setDataAndType(Uri.fromFile(new File(filePath)), type);
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                }
                activity.startActivity(intent);
            } catch (ActivityNotFoundException e) {
                LogUtil.e("ERROR: Open file failed . " + e.getMessage());
                CommonTool.showToast(R.string.im_uikit_history_file_none_tool);
            } catch (Exception e) {
                LogUtil.e("ERROR: Open file failed . " + e.getMessage());
                CommonTool.showToast(R.string.im_uikit_file_open_failed);
            }
        } else if ("*/*".equals(type)) {
            LogUtil.w("ERROR:No tool operate this file. " + filePath);
            CommonTool.showToast(R.string.im_uikit_history_file_none_tool);
        }
    }
}
