package com.xdja.im.core.repository.impl;

import com.google.gson.Gson;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.repository.interf.UserOperateRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.core.repository.impl
 * @Author: xdjaxa
 * @Creation: 2017-04-11 11:11
 * @Version V1.0
 * @Description:用户功能性模块实现
 */
public class UserOperateImpl implements UserOperateRepository {

    /**
     * 获取本地漫游设置的标识
     */
    final String SETTER_KEY_ROAM_SETTING = "roamSetting";

    /**
     * 用户账号标识
     */
    final String SETTER_KEY_USER_ACCOUNT = "userAccount";

    /**
     * 用户获取本地数据库是否为最新数据的标识
     */
    final String KEY_LOCAL_STATE = "localDbState";

    private CloudDataStore cloudDataStore;

    private DiskDataStore diskDataStore;
    /**
     * 用户信息缓存实体
     */
    private UserCache userCache;
    /**
     * 卡信息缓存实体
     */
    private CardCache cardCache;

    private DataMapper dataMapper;

    private Gson gson;

    @Inject
    public UserOperateImpl(CloudDataStore cloudDataStore,
                           DiskDataStore diskDataStore,
                           UserCache userCache,
                           CardCache cardCache,
                           DataMapper dataMapper,
                           Gson gson) {
        this.cloudDataStore = cloudDataStore;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
        this.cardCache = cardCache;
        this.dataMapper = dataMapper;
        this.gson = gson;
    }
}
