package com.xdja.im.lib.album;

import com.xdja.im.lib.album.bean.ImageItem;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.lib.album
 * @Author: xdjaxa
 * @Creation: 2017-04-24 11:58
 * @Version V1.0
 * @Description: 相册数据加载类
 */
public class ImageDataSource {

    /**
     * 已选图片集合
     */
    private static List<ImageItem> mSelectItemData = new ArrayList<>();

    private static List<ImageItem> mAllItemData = new ArrayList<>();

    private static class SingletonInstance {
        private static final ImageDataSource mInstance = new ImageDataSource();
    }

    private ImageDataSource() {
        mSelectItemData.clear();
    }

    public static ImageDataSource getInstance() {
        return SingletonInstance.mInstance;
    }

    public void addAll(List<ImageItem> data) {
        mAllItemData.clear();
        mAllItemData.addAll(data);
    }

    /**
     * 获取所有图片
     *
     * @return
     */
    public List<ImageItem> getAll() {
        return mAllItemData;
    }

    /**
     * 获取全部已选图片
     *
     * @return
     */
    public List<ImageItem> getSelects() {
        return mSelectItemData;
    }

    /**
     * 加入已选图片集合
     *
     * @param imageItem
     */
    public void add(ImageItem imageItem) {
        mSelectItemData.add(imageItem);
    }

    /**
     * 更新集合数据
     * @param imageItem
     */
    public void updateItem(ImageItem imageItem) {
        int index = 0;
        for (; index < mSelectItemData.size() ; index++) {
            if (mSelectItemData.get(index).equals(imageItem)) {
                break;
            }
        }
        if (index < mSelectItemData.size()) {
            mSelectItemData.remove(index);
            mSelectItemData.add(imageItem);
        } else {
            mSelectItemData.add(imageItem);
        }
    }

    /**
     * 移除
     *
     * @param imageItem
     */
    public void remove(ImageItem imageItem) {
        mSelectItemData.remove(imageItem);
    }

    /**
     * 是否存在
     *
     * @param imageItem
     * @return
     */
    public boolean contains(ImageItem imageItem) {
        return mSelectItemData.contains(imageItem);
    }

    /**
     * 大小
     *
     * @return
     */
    public int size() {
        return mSelectItemData.size();
    }

    /**
     * 清除所有缓存数据
     */
    public void clearCache() {
        mSelectItemData.clear();
        mAllItemData.clear();
    }
}