package com.xdja.im.lib.album.ui.adapter;

import android.app.Activity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.bean.PickerType;
import com.xdja.im.lib.album.listener.OnItemClickListener;
import com.xdja.im.lib.album.listener.OnItemDataChangedListener;
import com.xdja.im.lib.album.ui.viewholder.BaseViewHolder;
import com.xdja.im.lib.album.ui.viewholder.CameraViewHolder;
import com.xdja.im.lib.album.ui.viewholder.ImageViewHolder;
import com.xdja.im.lib.album.ui.viewholder.VideoViewHolder;
import com.xdja.im.uikit.R;

import java.util.List;

/**
 * @Package: com.xdja.im.lib.album.ui.adapter
 * @Author: xdjaxa
 * @Creation: 2017-04-24 16:01
 * @Version V1.0
 * @Description:图片显示适配器
 */
public abstract class ImagePickerAdapter extends RecyclerView.Adapter<BaseViewHolder> {

    public static final int ITEM_TYPE_IMAGE = 0x00;
    public static final int ITEM_TYPE_VIDEO = 0x01;
    public static final int ITEM_TYPE_CAMERA = 0x02;

    private Activity mActivity;

    private ImagePickerConfig mConfig;

    private List<ImageItem> mImageItemList;

    private int mItemType = ITEM_TYPE_IMAGE;

    public ImagePickerAdapter(Activity activity, List<ImageItem> datas) {
        this.mActivity = activity;
        this.mImageItemList = datas;
        this.mConfig = ImagePickerManager.getInstance().getConfig();
    }

    /**
     * 获取Item显示数据
     *
     * @param position
     * @return
     */
    public ImageItem getItemData(int position) {
        if (mConfig.getType() == ImagePickerConfig.TYPE_IMAGE) {
            return mImageItemList.get(position);
        } else {
            if (position == 0) {
                return null;
            } else {
                return mImageItemList.get(position - 1);
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        ImageItem item = getItemData(position);
        if (item == null) {
            return mItemType = ITEM_TYPE_CAMERA;    //相机
        } else {
            if (item.getType() == PickerType.TYPE_IMAGE) {
                return mItemType = ITEM_TYPE_IMAGE; //图片
            } else {
                return mItemType = ITEM_TYPE_VIDEO; //视频
            }
        }
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        BaseViewHolder viewHolder;
        if (mItemType == ITEM_TYPE_VIDEO) {
            viewHolder = new VideoViewHolder(mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_video, parent, false));
        } else if (mItemType == ITEM_TYPE_CAMERA) {
            viewHolder = new CameraViewHolder(mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_camera, parent, false));
        } else {
            viewHolder = new ImageViewHolder(mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_image, parent, false));
        }
        viewHolder.setOnItemClickListener(getOnItemClickListener());
        viewHolder.setOnItemDataChangedListener(getOnItemDataChangedListener());
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (holder != null) {
            holder.bindData(getItemData(position));
        }
    }

    @Override
    public int getItemCount() {
        return mImageItemList == null ? 0 : mImageItemList.size();
    }

    public abstract OnItemClickListener getOnItemClickListener();

    public abstract OnItemDataChangedListener getOnItemDataChangedListener();
}
