package com.xdja.im.lib.file;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.app.Fragment;

import com.xdja.im.lib.file.ui.activity.FileExplorerActivity;

/**
 * @Package: com.xdja.im.lib.file
 * @Author: xdjaxa
 * @Creation: 2017-04-26 9:02
 * @Version V1.0
 * @Description:文件浏览管理器
 */
public class FileExplorerManager {

    private static class SingletonInstance {
        private static final FileExplorerManager mInstance = new FileExplorerManager();
    }

    private FileExplorerManager() {
    }

    private FileExplorerConfig config;

    public static FileExplorerManager getInstance() {
        return SingletonInstance.mInstance;
    }

    public FileExplorerConfig getConfig(){
        if(config == null){
            config = new FileExplorerConfig();
        }
        return config;
    }

    public void setConfig(FileExplorerConfig config){
        this.config = config;
    }

    /**
     * 打开文件浏览器，从Fragment启动
     *
     * @param fragment    Fragment实例
     * @param requestCode 请求码
     */
    public void openFileExplorer(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), FileExplorerActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    /**
     * 打开文件浏览器，从Activity启动
     *
     * @param activity
     * @param requestCode
     */
    public void openFileExplorer(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(activity, FileExplorerActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }
}
