package com.xdja.im.lib.file.bean;

import java.util.List;

public class FileItemNode<T> {

    private T value;

    private List<FileItem> childList;

    private boolean isExpand;

    public int getSize() {
        return 1 + (childList != null ? childList.size() : 0);
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public List<FileItem> getChildList() {
        return childList;
    }

    public void setChildList(List<FileItem> childList) {
        this.childList = childList;
    }

    public boolean isExpand() {
        return isExpand;
    }

    public void setExpand(boolean expand) {
        isExpand = expand;
    }

    public boolean isLeaf() {
        return childList == null || childList.size() == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FileItemNode<?> that = (FileItemNode<?>) o;

        return !(getValue() != null ? !getValue().equals(that.getValue()) : that.getValue() != null);

    }

    @Override
    public int hashCode() {
        return getValue() != null ? getValue().hashCode() : 0;
    }
}
