package com.xdja.im.lib.file.ui.view;

import com.xdja.im.lib.file.bean.FileCollections;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileItemNode;
import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegate;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;

public class ViewChildPhotoDelegate implements ItemViewDelegate<FileItemNode> {

    @Override
    public int getItemViewLayoutId() {
        return R.layout.im_uikit_fragment_file_photo;
    }

    @Override
    public boolean isForViewType(FileItemNode item, int position) {
        return item.isLeaf();
    }

    @Override
    public void covert(ViewHolder viewHolder, FileItemNode fileItemNode, int position) {
        FileItem fileItem = (FileItem) fileItemNode.getValue();

        String filePath = fileItem.getFilePath();
        viewHolder.setImageWithPath(R.id.image_file_image, filePath, R.mipmap.im_uikit_pic_default);

        if (FileCollections.getInstance().getAllSelectFiles().contains(fileItem)) {
            viewHolder.setChecked(R.id.chx_file_fragment_select, true);
        } else {
            viewHolder.setChecked(R.id.chx_file_fragment_select, fileItem.isSelected());
        }
    }
}
