package com.xdja.im.uikit.action.options;

/**
 * @Package: com.xdja.im.uikit.action.options
 * @Author: xdjaxa
 * @Creation: 2017-09-12 11:58
 * @Version V1.0
 * @Description:
 */
public class ImOption {
    /**
     * 选项类型
     */
    private int optionType;
    /**
     * 选项名称
     */
    private String value;

    public ImOption(int optionType) {
        this.optionType = optionType;
    }

    public ImOption(int optionType, String value) {
        this.optionType = optionType;
        this.value = value;
    }

    public int getOptionType() {
        return optionType;
    }

    public void setOptionType(int optionType) {
        this.optionType = optionType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "ImOption{" +
                "optionType=" + optionType +
                ", value='" + value + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ImOption option = (ImOption) o;

        return optionType == option.optionType;

    }

    @Override
    public int hashCode() {
        return optionType;
    }
}
