package com.xdja.im.uikit.ui.presenter;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.presenter.command
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:26
 * @Version V1.0
 * @Description:
 */
public interface ChatListAdapterPresenter extends Presenter {
    /**
     * 消息重发
     *
     * @param position 当前item位置
     */
    void reSendMessage(int position);

    /**
     * 单独更新列表中的 一个视图/一条数据（单条刷新）
     *
     * @param position        当前视图位置
     * @param talkMessageBean 当前item数据
     */
    void updateItem(int position, TalkMessageBean talkMessageBean);

    /**
     * 动态调整ListView的显示位置
     *
     * @param position
     */
    void scrollTo(int position);

    /**
     * 删除列表中的 一个视图/一条数据（单条刷新）
     *
     * @param position item位置
     */
    void deleteItem(int position);

    /**
     * 消息撤回事件
     *
     * @param position
     */
    void recallMessage(int position);

    /**
     * 消息复制事件
     *
     * @param position
     */
    void copyMessage(int position);

    /**
     * 播放语音
     *
     * @param bean 消息体
     */
    void playVoice(TalkMessageBean bean);

    /**
     * 视频文件预览
     *
     * @param dataSource 消息体
     */
    void previewVideo(TalkMessageBean dataSource);

    /**
     * 点击图片
     *
     * @param dataSource
     */
    void previewImage(TalkMessageBean dataSource);

    /**
     * 网路加载文件
     *
     * @param fileInfo 消息体
     */
    void downLoadFile(FileInfo fileInfo);

    /**
     * 下载普通文件
     *
     * @param dataSource
     */
    void loadNormalFile(TalkMessageBean dataSource);

    /**
     * 打开普通文件
     *
     * @param dataSource 消息体
     */
    void openNormalFile(TalkMessageBean dataSource);

    /**
     * 打开设置界面
     *
     * @param talkId
     * @param talkType
     */
    void openSetting(String talkId, int talkType);

    /**
     * 获取语音消息是否正在播放，必须使用文件绝对路径和消息Id同时进行约束。
     * 比如： 1）不同文件夹下语音文件名称相同
     * 2）收到重复的语音消息
     * 在这以上两种情况下，如果在同一回话中，则会播放错误
     *
     * @return
     */
    boolean getVoiceMessageIsPlaying(FileInfo fileInfo);

    /**
     * 状态更新
     *
     * @param talkMessageBean
     */
    void sendReadReceipt(final TalkMessageBean talkMessageBean);

    /**
     * 播放销毁动画
     *
     * @param bean
     */
    void postDestroyAnimate(final TalkMessageBean bean);

    /**
     * 获取当前位置对应的上一条消息
     *
     * @param position 当前位置
     * @return
     */
    TalkMessageBean getTalkMessage(int position);

    /**
     * 获取消息完整实体类
     *
     * @param msgId 消息ID
     */
    void getTalkMessageEntity(long msgId, Subscriber<TalkMessageBean> subscriber);

    /**
     * 获取账号对应的用户信息
     *
     * @param account
     * @param talkType
     * @param subscriber
     */
    void getAccount(String account, int talkType, Subscriber<AccountBean> subscriber);
}
