package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:48
 * @Version 1.0
 * @Description:群组会话显示控件
 */
public class ViewGroupItem extends ViewSessionItem {

    public static final String SEPARATOR = ": ";

    private TextView senderName;

    private TextView senderNameSeparator;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    protected void injectView() {
        super.injectView();

        View view = getView();
        if (null != view) {
            senderName = (TextView) view.findViewById(R.id.tv_senderName);
            senderNameSeparator = (TextView) view.findViewById(R.id.tv_senderNameSeparate);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);

        updateSessionSenderInfo();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        senderName.setVisibility(View.GONE);
        senderNameSeparator.setVisibility(View.GONE);
    }

    @Override
    protected CharSequence getContent(String displayName) {
        if (dataSource.getLastMsg() != null && dataSource.getLastMsg().isMine()) {
            senderName.setVisibility(View.GONE);
            senderNameSeparator.setVisibility(View.GONE);
            return getMessageContent();
        } else {
            senderName.setVisibility(View.VISIBLE);
            senderName.setText(displayName);
            senderNameSeparator.setVisibility(View.VISIBLE);
            return getMessageContent();
        }
    }

    /**
     * 获取消息显示内容
     *
     * @return 消息体
     */
    private CharSequence getMessageContent() {
        TalkMessageBean talkMessageBean = dataSource.getLastMsg();

        //草稿处理
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            CharSequence content = formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content,
                    getActivity(),
                    EmotionConfig.FACE_ITEM_SMALL_VALUE);
        }

        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }

        int messageType = talkMessageBean.getMessageType();
        //普通消息
        switch (messageType) {
            case ConstDef.MSG_TYPE_TEXT:
                return EmotionUtils.formatSpanContent(dataSource.getContent(),
                        getActivity(), EmotionConfig.FACE_ITEM_SMALL_VALUE);
            case ConstDef.MSG_TYPE_VOICE:
                return getStringRes(R.string.im_uikit_voice);
            case ConstDef.MSG_TYPE_VIDEO:
                return getStringRes(R.string.im_uikit_video);
            case ConstDef.MSG_TYPE_PHOTO:
                return getStringRes(R.string.im_uikit_image);
            case ConstDef.MSG_TYPE_FILE:
                return getStringRes(R.string.im_uikit_file);
            default:
                return dataSource.getContent() == null ? "" : dataSource.getContent();
        }
    }

    private void updateSessionSenderInfo() {
        if (null != dataSource.getLastMsgAccount() && !dataSource.getLastMsg().isMine()
                && dataSource.getLastMsgType() != ConstDef.MSG_TYPE_PRESENTATION) {
            senderName.setVisibility(View.VISIBLE);
            senderNameSeparator.setVisibility(View.VISIBLE);
            updateSenderView(getPresenter().getAccount(dataSource.getLastMsgAccount(), ConstDef.CHAT_TYPE_P2P));
        } else {
            senderName.setVisibility(View.GONE);
            senderNameSeparator.setVisibility(View.GONE);
        }
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null == accountBean) return;
        senderName.setText(accountBean.getDisplayName());
    }
}
