package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:42
 * @Version V1.0
 * @Description:
 */
public class ViewSendImageItem extends BaseSendItem {

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * 闪信标识
     */
    private ImageView mBombFlagImg;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mBombFlagImg = (ImageView) findViewById(R.id.img_bomb_flag);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewImage(dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        ImageFileInfo fileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }

        //加载图片
        loadImage(fileInfo.getFilePath());

        //闪信标识
        if (dataSource.isBomb()) {
            mBombFlagImg.setVisibility(View.VISIBLE);
        }
    }

    private void loadImage(String filePath) {
        //本地图片存在
        if (FileUtils.isFileExists(filePath)) {
            mChatImage.loadImage(filePath);
        } else {
            LogUtil.w("file is not exit.");
            mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

}
