package com.xdja.im.uikit.utils.sys;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

import com.xdja.im.core.model.screen.ScreenInfo;

import java.lang.reflect.Method;

/**
 * @Package: com.xdja.im.uikit.utils.sys
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:07
 * @Version V1.0
 * @Description:
 */
public class ScreenUtil {

    /**
     * 获取屏幕原始尺寸宽度
     *
     * @param context 上下文
     * @return 返回屏幕原始尺寸宽度
     */
    public static int getWidthPixels(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Configuration cf = context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == Configuration.ORIENTATION_LANDSCAPE) {// 横屏
            //noinspection SuspiciousNameCombination
            return displayMetrics.heightPixels;
        } else if (ori == Configuration.ORIENTATION_PORTRAIT) {// 竖屏
            return displayMetrics.widthPixels;
        }
        return 0;
    }

    /**
     * dp2px
     *
     * @param context 上下文
     * @param dpValue dp尺寸
     * @return 返回转化成px的尺寸
     */
    public static int dp2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    /**
     * px2dp
     *
     * @param context 上下文
     * @param pxValue px尺寸
     * @return 返回转化成dp的尺寸
     */
    @SuppressWarnings("unused")
    public static int px2dp(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }


    /**
     * 获取屏幕原始尺寸高度，包括虚拟功能键高度
     *
     * @param context 上下文
     * @return 返回屏幕原始尺寸高度，包括虚拟功能键高度
     */
    private static int getDpi(Context context) {
        int dpi = 0;
        WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        @SuppressWarnings("rawtypes")
        Class c;
        try {
            c = Class.forName("android.view.Display");
            @SuppressWarnings("unchecked")
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke(display, displayMetrics);
            dpi = displayMetrics.heightPixels;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    /**
     * 获取虚拟按键的高度
     *
     * @param context 上下文
     * @return 返回虚拟按键高度
     */
    public static int getBottomStatusHeight(Context context) {
        int totalHeight = getDpi(context);

        int contentHeight = getScreenHeight(context);
        return totalHeight - contentHeight;
    }

    /**
     * 获得屏幕高度
     *
     * @param context 上下文
     * @return 返回屏幕高度
     */
    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    /**
     * 获取屏幕相关信息
     *
     * @param activity
     * @return
     */
    public static ScreenInfo getScreenInfo(Activity activity) {
        WindowManager wm = activity.getWindowManager();
        DisplayMetrics metric = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metric);
        ScreenInfo screenInfo = new ScreenInfo();
        screenInfo.setDensity(metric.density);// 屏幕密度（0.75 / 1.0 / 1.5）
        screenInfo.setDensityDpi(metric.densityDpi);// 屏幕密度DPI（120 / 160 / 240）
        screenInfo.setHeight(metric.heightPixels);// 屏幕高度（像素）
        screenInfo.setWidth(metric.widthPixels);// 屏幕宽度（像素）
        return screenInfo;
    }
}
