package com.xdja.im.uikit.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.TextView;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-09-15 15:41
 * @Version V1.0
 * @Description:
 */
public class TipsTextView extends TextView {

    public static final int MSG_SHOW = 0;

    public static final int MSG_GONE = 1;

    public TipsTextView(Context context) {
        super(context);
    }

    public TipsTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public TipsTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void showTips() {
        setVisibility(VISIBLE);
        mHandler.sendEmptyMessageDelayed(MSG_GONE, 1000);
    }

    public void hideTips() {
        if (getVisibility() == VISIBLE) {
            setVisibility(GONE);

            mHandler.removeMessages(MSG_SHOW);
            mHandler.removeMessages(MSG_GONE);
        }
    }

    private Handler mHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            switch (msg.what) {
                case MSG_GONE:
                    hideTips();
                    break;
            }
        }
    };
}
