package com.xdja.im.base.di.component;


import android.content.Context;

import com.google.gson.Gson;
import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.module.ApplicationModule;
import com.xdja.im.base.di.module.CacheModule;
import com.xdja.im.base.di.module.HttpModule;
import com.xdja.im.base.di.module.ImageLoaderModule;
import com.xdja.im.base.di.module.UtilModule;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.PropertyCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.common.utils.CommonTool;

import javax.inject.Singleton;

import dagger.Component;
import okhttp3.OkHttpClient;

/**
 * @Package:com.sontak.mvpmodel.di.component
 * @Author:Lei
 * @Creation:2017-03-20 23:30
 * @Version 1.0
 * @Description:
 */
@Singleton
@Component(modules = {
        ApplicationModule.class,
        CacheModule.class,
        HttpModule.class,
        UtilModule.class,
        ImageLoaderModule.class})
public interface ApplicationComponent {

    @Scoped(DiConfig.CONTEXT_SCOPE_APP)
    Context context();

    UserCache accountCache();

    CardCache cardCache();

    ConfigCache configCache();

    PropertyCache propertyCache();

    OkHttpClient okHttpsClient();

    Gson gson();

    CommonTool commonTool();

    ImageLoader imageLoader();
}
