package com.xdja.im.common.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

/**
 * @Package: com.xdja.im.common.database
 * @Author: xdjaxa
 * @Creation: 2017-04-12 19:45
 * @Version V1.0
 * @Description:
 */
public class DatabaseManager {

    private static final String DATABASE_NAME = "imuikit.db";
    private static final int DATABASE_VERSION = 1;

    private DatabaseHelper dbHelper;

    private static class SingletonInstance{
        private static final DatabaseManager mInstance = new DatabaseManager();
    }

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return SingletonInstance.mInstance;
    }

    public void initDatabase(Context context, String account) {
        getInstance().dbHelper = new DatabaseHelper(new DBContext(context, account),
                DATABASE_NAME, null, DATABASE_VERSION);
    }

    public synchronized SQLiteDatabase getDatabase() {
        if (dbHelper == null) {
            throw new RuntimeException("database already closed...");
        }
        return dbHelper.getReadableDatabase();
    }

    public synchronized void close() {
        if (dbHelper != null) {
            dbHelper.close();
        }
        dbHelper = null;
    }
}
