package com.xdja.im.common.utils;

import android.content.Context;

import com.xdja.im.uikit.ImUiKit;

import java.io.File;

/**
 * @Package: com.xdja.im.common.utils
 * @Author: xdjaxa
 * @Creation: 2017-05-22 18:22
 * @Version V1.0
 * @Description:data下缓存文件保存路径
 */
public class CachePath {
    /**
     * ImUikit保存文件的根文件夹名
     */
    public static final String ROOT_KIT_PATH = "xdja_uikit";
    /**
     * uikit数据库父目录
     */
    public static final String PARENT_DB_PATH = "databases";
    /**
     * uikit缓存父目录
     */
    public static final String PARENT_CACHE_PATH = "cache";
    /**
     * uikit文件父目录
     */
    public static final String PARENT_FILE_PATH = "files";
    /**
     * uikit文件父目录
     */
    public static final String PARENT_PREFS_PATH = "shared_prefs";
    /**
     * uikit图片缓存目录
     */
    public static final String PARENT_IMAGE_PATH = "image_manager_disk_cache";

    /**
     * UiKit data数据缓存父目录 /data/data/packageName/xdja_uikit
     *
     * @return
     */
    public static String getRootKitPath() {
        Context context = ImUiKit.getInstance().getContext();
        if (context != null) {
            return context.getFilesDir().getParent() +
                    File.separator + ROOT_KIT_PATH;
        } else {
            // TODO: 2017/8/7
            return "";
        }
    }

    /**
     * UiKit 缓存父目录 /data/data/.../xdja_uikit/cache
     *
     * @return
     */
    public static String getParentCachePath() {
        return getRootKitPath() + File.separator + PARENT_CACHE_PATH;
    }

    /**
     * UIKIt图片文件缓存路径
     *
     * @return /data/data/appName/xdja_uikit/cache/image_manager_disk_cache
     */
    public static String getImageCachePath() {
        return getParentCachePath() + File.separator + PARENT_IMAGE_PATH;
    }

    /**
     * UiKit 数据库父目录 /data/data/.../xdja_uikit/databases
     *
     * @return
     */
    public static String getParentDbPath() {
        return getRootKitPath() + File.separator + PARENT_DB_PATH;
    }

    /**
     * UiKit 文件目录 /data/data/.../xdja_uikit/files
     *
     * @return
     */
    public static String getParentFilePath() {
        return getRootKitPath() + File.separator + PARENT_FILE_PATH;
    }

    /**
     * UiKit 缓存父目录 /data/data/.../xdja_uikit/shared_prefs
     *
     * @return
     */
    public static String getParentPrefsPath() {
        return getRootKitPath() + File.separator + PARENT_PREFS_PATH;
    }
}
