package com.xdja.im.core.model.event;

import com.xdja.im.core.model.message.TalkSessionBean;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-05-07 11:10
 * @Version V1.0
 * @Description:会话列表相关事件
 */
public class IMProxySessionEvent {

    public static class SessionEvent {
        /**
         * 会话ID
         */
        private String talkId;
        /**
         * 会话对象
         */
        private TalkSessionBean sessionBean;

        public String getTalkId() {
            return talkId;
        }

        public void setTalkId(String talkId) {
            this.talkId = talkId;
        }

        public TalkSessionBean getSessionBean() {
            return sessionBean;
        }

        public void setSessionBean(TalkSessionBean sessionBean) {
            this.sessionBean = sessionBean;
        }
    }

    /**
     * 创建新会话事件定义
     */
    public static class CreateNewSessionEvent extends SessionEvent {
    }

    /**
     * 删除会话事件定义
     */
    public static class DeleteSessionEvent extends SessionEvent {
    }

    /**
     * 刷新单条会话事件定义
     */
    public static class RefreshSessionEvent extends SessionEvent {
        /**
         * 改标识用于判断是否只更新会话内容（一般用于聊天界面返回数据处理）
         */
        private boolean isUpdateData;

        public boolean isUpdateData() {
            return isUpdateData;
        }

        public void setUpdateData(boolean updateData) {
            isUpdateData = updateData;
        }
    }

    /**
     * 刷新会话列表事件定义
     */
    public static class RefreshSessionListEvent extends SessionEvent {
    }

    /**
     * 清除未读消息
     */
    public static class ClearUnReadMsgEvent extends SessionEvent {
    }

}
