package com.xdja.im.core.model.message.file;

/**
 * @Package: com.xdja.im.core.model.message.file
 * @Author: xdjaxa
 * @Creation: 2017-04-18 19:42
 * @Version V1.0
 * @Description:图片文件消息信息
 */
public class ImageFileInfo extends FileInfo {

    /**
     * 是否发送原图
     */
    private boolean bOriginal;

    /**
     * 高清缩略图
     */
    private FileInfo hdFileInfo;

    /**
     * 原图
     */
    private FileInfo rawFileInfo;

    /**
     * 下载图片的类型(缩略，高清，原图)
     * */
    private int type;

    public boolean isOriginal() {
        return bOriginal;
    }

    public void setOriginal(boolean bOriginal) {
        this.bOriginal = bOriginal;
    }

    public FileInfo getHdFileInfo() {
        return hdFileInfo;
    }

    public void setHdFileInfo(FileInfo hdFileInfo) {
        this.hdFileInfo = hdFileInfo;
    }

    public FileInfo getRawFileInfo() {
        return rawFileInfo;
    }

    public void setRawFileInfo(FileInfo rawFileInfo) {
        this.rawFileInfo = rawFileInfo;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "ImageFileInfo{" +
                "bOriginal=" + bOriginal +
                ", hdFileInfo=" + hdFileInfo +
                ", rawFileInfo=" + rawFileInfo +
                "} " + super.toString();
    }
}
