package com.xdja.im.core.model.options;

/**
 * @Package: com.xdja.im.core.model.options
 * @Author: xdjaxa
 * @Creation: 2017-04-17 19:02
 * @Version V1.0
 * @Description: 消息选择面板
 */
public class PanelOption {

    public enum ACTION {
        TEXT(0),
        IMAGE(0),
        AUDIO(0),
        VIDEO(0),
        FILE(0);

        /**
         * 操作类型：0 ：支持 1：不支持
         */
        private int mode;

        ACTION(int mode) {
            this.mode = mode;
        }

        /**
         * 获取操作模式
         *
         * @return 0 ：支持 1：不支持
         */
        public int getMode() {
            return mode;
        }

        /**
         * 设置操作模式
         *
         * @param mode 0 ：支持 1：不支持
         */
        public void setMode(int mode) {
            this.mode = mode;
        }

        /**
         * 是否支持该操作类型
         *
         * @return {@code true} 支持 {@code false} 不支持
         */
        public boolean isSupport() {
            return mode == 0;
        }
    }
}
