package com.xdja.im.core.proxy;

import com.xdja.im.common.database.helper.IMSettingHelper;
import com.xdja.im.core.model.param.RemindAction;
import com.xdja.im.core.model.param.SettingParam;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-08-09 10:31
 * @Version V1.0
 * @Description:
 */
public class IMUiKitSettingProxyImpl implements IMUiKitSettingProxy {

    private IMUiKitSettingProxyImpl() {
    }

    private static class SingletonInstance {
        private static final IMUiKitSettingProxyImpl mInstance = new IMUiKitSettingProxyImpl();
    }


    public static IMUiKitSettingProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public SettingParam getSettingParam() {
        return IMSettingHelper.getSettingParam();
    }

    @Override
    public void setRemindType(@RemindAction.Action int action) {
        switch (action) {
            case RemindAction.ACTION_CLOSE:
                IMSettingHelper.setRemindType(0);
                break;
            case RemindAction.ACTION_OPEN:
                IMSettingHelper.setRemindType(1);
                break;
            case RemindAction.ACTION_VOICE_CLOSE:
                IMSettingHelper.setRemindVoiceType(0);
                break;
            case RemindAction.ACTION_VOICE_OPEN:
                IMSettingHelper.setRemindVoiceType(1);
                break;
            case RemindAction.ACTION_VIBRATE_CLOSE:
                IMSettingHelper.setRemindVibrateType(0);
                break;
            case RemindAction.ACTION_VIBRATE_OPEN:
                IMSettingHelper.setRemindVibrateType(1);
                break;
        }
    }

    @Override
    public void setReceiveMode(boolean isOpen) {
        IMSettingHelper.setReceiverMode(isOpen ? 1 : 0);
    }

    @Override
    public void setDisturbMode(boolean isOpen) {
        IMSettingHelper.setDisturbMode(isOpen ? 1 : 0);
    }

    @Override
    public void setDisturbStart(long disturbStart) {
        IMSettingHelper.setDisturbStart(disturbStart);
    }

    @Override
    public void setDisturbEnd(long disturbEnd) {
        IMSettingHelper.setDisturbEnd(disturbEnd);
    }
}
