package com.xdja.im.core.repository.impl;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.repository.interf.UserOperateRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.entity.KeyValuePair;
import com.xdja.im.uikit.entity.NoDisturbConfig;
import com.xdja.im.uikit.entity.SettingTopConfig;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

/**
 * @Package: com.xdja.im.core.repository.impl
 * @Author: xdjaxa
 * @Creation: 2017-04-11 11:11
 * @Version V1.0
 * @Description:用户功能性模块实现
 */
public class UserOperateImpl implements UserOperateRepository {

    /**
     * 获取本地漫游设置的标识
     */
    final String SETTER_KEY_ROAM_SETTING = "roamSetting";

    /**
     * 用户账号标识
     */
    final String SETTER_KEY_USER_ACCOUNT = "userAccount";

    /**
     * 用户获取本地数据库是否为最新数据的标识
     */
    final String KEY_LOCAL_STATE = "localDbState";

    private CloudDataStore cloudDataStore;

    private DiskDataStore diskDataStore;
    /**
     * 用户信息缓存实体
     */
    private UserCache userCache;
    /**
     * 卡信息缓存实体
     */
    private CardCache cardCache;

    private DataMapper dataMapper;

    private Gson gson;

    @Inject
    public UserOperateImpl(CloudDataStore cloudDataStore,
                           DiskDataStore diskDataStore,
                           UserCache userCache,
                           CardCache cardCache,
                           DataMapper dataMapper,
                           Gson gson) {
        this.cloudDataStore = cloudDataStore;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
        this.cardCache = cardCache;
        this.dataMapper = dataMapper;
        this.gson = gson;
    }

    @Override
    public void getAllSessionParams(Subscriber<List<SessionParam>> subscriber) {
        final String account = userCache.get().getAccount();
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        diskDataStore.queryIntegerSharePref(KEY_LOCAL_STATE)
                .subscribeOn(Schedulers.newThread())
                .flatMap(
                        new Func1<Boolean, Observable<List<SessionParam>>>() {
                            @Override
                            public Observable<List<SessionParam>> call(Boolean aBoolean) {
                                return Observable.zip(
                                        cloudDataStore.getNoDisturbSettingsAtCloud(account),
                                        cloudDataStore.getSettingTopSettingsAtCloud(account),
                                        new Func2<List<NoDisturbConfig>, List<SettingTopConfig>, List<SessionParam>>() {
                                            @Override
                                            public List<SessionParam> call(List<NoDisturbConfig> noDisturbConfigs, List<SettingTopConfig> settingTopConfigs) {
                                                List<SessionParam> results = new ArrayList<>();

                                                int noDisturbSize = noDisturbConfigs.size();

                                                for(int i = 0;i < noDisturbSize;i++){
                                                    SessionParam rConfig = new SessionParam();
                                                    NoDisturbConfig config = noDisturbConfigs.get(i);

                                                    SettingTopConfig sConfig = new SettingTopConfig();
                                                    sConfig.setSessionId(config.getSessionId());
                                                    final String sessionFlag = ToolUtils.getSessionTag(config.getSessionId(), config.getSessionType());
                                                    rConfig.setSessionFlag(sessionFlag);
                                                    rConfig.setDisturb(true);

                                                    if(settingTopConfigs.contains(sConfig)){
                                                        int index = settingTopConfigs.indexOf(sConfig);
                                                        rConfig.setTop(true);
                                                        settingTopConfigs.remove(index);
                                                    } else {
                                                        rConfig.setTop(false);
                                                    }
                                                    results.add(rConfig);
                                                }

                                                int settingSize = settingTopConfigs.size();
                                                if(settingSize >= 0){
                                                    for(int i = 0;i < settingSize;i++){
                                                        SessionParam rConfig = new SessionParam();
                                                        SettingTopConfig config = settingTopConfigs.get(i);
                                                        rConfig.setSessionFlag(config.getSessionId());
                                                        rConfig.setDisturb(false);
                                                        rConfig.setTop(true);
                                                        results.add(rConfig);
                                                    }
                                                }
                                                return results;
                                            }
                                        }
                                ).flatMap(
                                        new Func1<List<SessionParam>, Observable<List<SessionParam>>>() {
                                            @Override
                                            public Observable<List<SessionParam>> call(List<SessionParam> sessionConfigs) {
                                                return diskDataStore.saveSettingTopAndNodisturb2Local(sessionConfigs);
                                            }
                                        }
                                );
                            }

                        }
                )
                .flatMap(new Func1<List<SessionParam>, Observable<List<SessionParam>>>() {
                    @Override
                    public Observable<List<SessionParam>> call(final List<SessionParam> configs) {
                        KeyValuePair<String,Integer> keyValuePair = new KeyValuePair<>();
                        keyValuePair.setKey(KEY_LOCAL_STATE);
                        keyValuePair.setValue(1);
                        return diskDataStore.saveIntKeyValuePairs(keyValuePair)
                                .flatMap(
                                        new Func1<Boolean, Observable<List<SessionParam>>>() {
                                            @Override
                                            public Observable<List<SessionParam>> call(Boolean aBoolean) {
                                                if (aBoolean) {
                                                    return Observable.just(configs);
                                                }else{
                                                    return Observable.error(new Throwable(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_conversation_data_save_fail)));
                                                }
                                            }
                                        }
                                );
                    }
                } )
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }
}
