package com.xdja.im.lib.action.listener;

/**
 * @Package:com.xdja.im.uikit.view.chatdetail.listener
 * @Author:Lei
 * @Creation:2017-04-23 09:14
 * @Version 1.0
 * @Description:输入操作栏动作回调接口
 */
public interface IChatActionCallback {

    /**
     * 点击隐藏按钮的回调
     */
    void onVirtualViewCallBack();

    /**
     * action面板控制控件的回调
     *
     */
    void onMoreCheckChanged();

    /**
     * 闪信控制控件的回调
     *
     */
    void onShanCheckChanged();

    /**
     * 输入方式控制控件的回调
     *
     * @param isChecked
     */
    void onInputCheckChanged(boolean isChecked);

    /**
     * 发送文本消息的回调
     */
    void onSendTextCallBack();

    /**
     * 输入控件被点击的回调
     */
    void onInputEareTouchCallBack();

    /**
     * 录音完成回调
     *
     * @param seconds 录音时长
     * @param filePath 录音文件路径
     */
    void onRecorderFinish(int seconds, String filePath);
}
