package com.xdja.im.lib.album;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.lib.album
 * @Author: xdjaxa
 * @Creation: 2017-04-24 11:43
 * @Version V1.0
 * @Description:图片相关配置信息
 */
public class ImagePickerConfig {

    /**
     *  ImSdk生成的缩略图的文件前缀名
     */
    public static final String THUMBNAIL_FILE_PREFIX = "th_";

    /**
     *  ImSdk生成的缩略图的文件后缀名
     */
    public static final String THUMBNAIL_FILE_SUFFIX = ".jpeg";

    /**
     * 图片缩略图缓存信息（就目前项目，路径必填）
     */
    private String cachePath;

    /**
     * 是否需要生成缩略图信息，默认生成缩略图
     */
    private boolean bNeedCreateThumb = true;

    /**
     * 最多选择张图片个数，默认9张
     */
    public static final int MAX_SELECT_NUM = 9;

    /**
     * 最大可选择发送文件大小，默认30M
     */
    public static final long MAX_SELECT_SIZE = 30 * 1024 * 1024;

    /**
     * 每行显示个数，默认是3
     */
    public static final int COLUMN_NUM = 3;

    /**
     * 单选
     */
    public static final int MODE_SINGLE = 0X001;
    /**
     * 多选
     */
    public static final int MODE_MULTIPLE = 0X002;

    @IntDef({MODE_SINGLE, MODE_MULTIPLE})
    @Retention(RetentionPolicy.SOURCE)
    @interface Mode {
    }

    /**
     * 图片类型
     */
    public static final int TYPE_IMAGE = 0x00;

    /**
     * 支持相机和图片
     */
    public static final int TYPE_WITH_CAMERA = 0x02;

    /**
     * 支持相机、图片、视频
     */
    public static final int TYPE_ALL = 0x01;

    @IntDef({TYPE_IMAGE, TYPE_WITH_CAMERA, TYPE_ALL})
    @Retention(RetentionPolicy.SOURCE)
    @interface TYPE {
    }

    /**
     * 选择模式
     */
    @Mode
    private int mode = MODE_SINGLE;

    /**
     * 栏目可支持的类型
     */
    @TYPE
    private int type = TYPE_IMAGE;

    /**
     * 可选图片个数
     */
    private int maxSelectNum = MAX_SELECT_NUM;

    /**
     * 图片大小限制
     */
    private long maxSize = MAX_SELECT_SIZE;

    /**
     * 每行显示个数
     */
    private int columnNum = COLUMN_NUM;

    public String getCachePath() {
        return cachePath;
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    public boolean isbNeedCreateThumb() {
        return bNeedCreateThumb;
    }

    public void setbNeedCreateThumb(boolean bNeedCreateThumb) {
        this.bNeedCreateThumb = bNeedCreateThumb;
    }

    @Mode
    public int getMode() {
        return mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @TYPE
    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMaxSelectNum() {
        return maxSelectNum;
    }

    public void setMaxSelectNum(int maxSelectNum) {
        this.maxSelectNum = maxSelectNum;
    }

    public long getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public int getColumnNum() {
        return columnNum;
    }

    public void setColumnNum(int columnNum) {
        this.columnNum = columnNum;
    }
}
