package com.xdja.im.lib.file.widget.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

public class BaseMultiItemTypeAdapter<T> extends RecyclerView.Adapter<ViewHolder> {

    protected Context context;
    protected List<T> dataSources;

    private OnItemClickListener clickListener;
    private ItemViewDelegateManager delegateManager;

    public BaseMultiItemTypeAdapter(Context context, List<T> dataSources) {
        this.context = context;
        this.dataSources = dataSources;
        delegateManager = new ItemViewDelegateManager();
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ItemViewDelegate delegate = delegateManager.getItemViewDelegate(viewType);
        int layoutId = delegate.getItemViewLayoutId();
        ViewHolder holder = ViewHolder.createViewHolder(context, parent, layoutId);
        onViewCreated(holder, holder.getConvertView());
        setListener(parent, holder, viewType);
        return holder;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        convert(holder, dataSources.get(position));
    }

    protected void setListener(ViewGroup parent, final ViewHolder holder, int viewType) {
        holder.getConvertView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (clickListener != null) {
                    int position = holder.getAdapterPosition();
                    clickListener.onItemClick(holder.getConvertView(), holder, position);
                }
            }
        });

        holder.getConvertView().setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                if (clickListener != null) {
                    int position = holder.getAdapterPosition();
                    return clickListener.onItemLongClick(holder.getConvertView(), holder, position);
                }
                return false;
            }
        });
    }

    protected void onViewCreated(ViewHolder holder, View currentView) {

    }

    public void convert(ViewHolder holder, T t) {
        delegateManager.covert(holder, t, holder.getAdapterPosition());
    }

    @Override
    public int getItemViewType(int position) {
        if (!useDelegateManager()) {
            return super.getItemViewType(position);
        }
        return delegateManager.getItemViewType(dataSources.get(position), position);
    }

    @Override
    public int getItemCount() {
        return dataSources != null ? dataSources.size() : 0;
    }

    public boolean useDelegateManager() {
        return delegateManager.getItemViewDelegateCount() > 0;
    }

    public void addItemViewDelegate(ItemViewDelegate<T> delegate) {
        delegateManager.addDelegate(delegate);
    }

    public void addItemViewDelegate(int viewType ,ItemViewDelegate<T> delegate){
        delegateManager.addDelegate(viewType, delegate);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        clickListener = listener;
    }

    public interface OnItemClickListener {
        void onItemClick(View view, ViewHolder holder, int position);

        boolean onItemLongClick(View view, ViewHolder holder, int position);
    }
}
