package com.xdja.im.lib.video.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @Package: com.xdja.im.lib.video.bean
 * @Author: xdjaxa
 * @Creation: 2017-05-13 15:45
 * @Version V1.0
 * @Description:
 */
public class VideoItem extends FileBean implements Parcelable{

    /**
     * 视频时长
     */
    private int duration;
    /**
     * 视频源文件名称
     */
    private String rawFileName;
    /**
     * 视频源文件路径
     */
    private String rawFilePath;
    /**
     * 视频源文件大小
     */
    private long rawFileSize;
    /**
     * 视频源文件后缀
     */
    private String rawSuffix;

    public VideoItem() {
    }

    public int getDuration() {
        return duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getRawFileName() {
        return rawFileName;
    }

    public void setRawFileName(String rawFileName) {
        this.rawFileName = rawFileName;
    }

    public String getRawFilePath() {
        return rawFilePath;
    }

    public void setRawFilePath(String rawFilePath) {
        this.rawFilePath = rawFilePath;
    }

    public long getRawFileSize() {
        return rawFileSize;
    }

    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    public String getRawSuffix() {
        return rawSuffix;
    }

    public void setRawSuffix(String rawSuffix) {
        this.rawSuffix = rawSuffix;
    }

    protected VideoItem(Parcel in) {
        super(in);
        duration = in.readInt();
        rawFileName = in.readString();
        rawFilePath = in.readString();
        rawFileSize = in.readLong();
        rawSuffix = in.readString();
    }

    public static final Creator<VideoItem> CREATOR = new Creator<VideoItem>() {
        @Override
        public VideoItem createFromParcel(Parcel in) {
            return new VideoItem(in);
        }

        @Override
        public VideoItem[] newArray(int size) {
            return new VideoItem[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(duration);
        dest.writeString(rawFileName);
        dest.writeString(rawFilePath);
        dest.writeLong(rawFileSize);
        dest.writeString(rawSuffix);
    }
}
