package com.xdja.im.uikit.ui.view;

import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:23
 * @Version V1.0
 * @Comment:
 */
public class ViewSessionList extends FragmentSuperBaseView<SessionListPresenter>
        implements SessionListVu {

    /**
     * 会话列表
     */
    private ListView mChatSessionList;
    /**
     * 加载进度控件
     */
    private ProgressBar mLoadingPBar;
    /**
     * 消息列表为空显示view
     */
    private TextView mEmptyHintTv;
    /**
     * 长按Item弹出的控件
     */
    private BaseListDialog mPopDialog;
    /**
     * 弹框选项事件
     */
    protected List<ImOption> mImOptions = new ArrayList<>();

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatSessionList = (ListView) findViewById(R.id.rv_session_list);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_loading);
        mEmptyHintTv = (TextView) findViewById(R.id.tv_empty);
        mChatSessionList.setEmptyView(mEmptyHintTv);

        mPopDialog = new BaseListDialog(getContext()) {
            @Override
            public List<ImOption> getOptions() {
                return buildImOptions();
            }
        };
        setListener();
    }

    private void setListener() {
        mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                getPresenter().onListItemClick(position);
            }
        });
        mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                return showPopDialog(position);
            }
        });
        mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                dismissPopDialog();
                switch (option.getOptionType()) {
                    case Constant.ITEM_SESSION_DELETE:      //会话删除
                        getPresenter().deleteSession(itemPosition);
                        break;
                    case Constant.ITEM_SESSION_SETTOP:      //会话置顶
                        getPresenter().setSessionTop(itemPosition);
                        break;
                    case Constant.ITEM_SESSION_CANCELTOP:
                        getPresenter().deleteSessionTop(itemPosition);
                        break;

                    case Constant.ITEM_SESSION_SETDISTURB:  //会话免打扰
                        getPresenter().setDisturb(itemPosition);
                        break;
                    case Constant.ITEM_SESSION_CLOSEDISTURB:
                        getPresenter().deleteDisturb(itemPosition);
                        break;
                }
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        mChatSessionList.setAdapter(adapter);
        mEmptyHintTv.setVisibility(View.GONE);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        mLoadingPBar.setVisibility(visibility);
    }

    private List<ImOption> buildImOptions() {
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_DELETE, getStringRes(R.string.im_uikit_session_option_delete)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_SETTOP, getStringRes(R.string.im_uikit_session_option_settop)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_CANCELTOP, getStringRes(R.string.im_uikit_session_option_canceltop)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_SETDISTURB, getStringRes(R.string.im_uikit_session_option_opendisturb)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_CLOSEDISTURB, getStringRes(R.string.im_uikit_session_option_closedisturb)));
        return mImOptions;
    }

    /**
     * 显示选择框
     */
    private boolean showPopDialog(int position) {
        List<ImOption> data = new ArrayList<>();

        data.add(mImOptions.get(0));
        if (!getPresenter().isSessionTop(position)) {
            data.add(mImOptions.get(1));
        } else {
            data.add(mImOptions.get(2));
        }

        // TODO: 2017/9/12 需求：要求不显示免打扰 
        if (!getPresenter().isDisturb(position)) {
            data.add(mImOptions.get(3));
        } else {
            data.add(mImOptions.get(4));
        }

        mPopDialog.addData(data);
        mPopDialog.show(position);
        return true;
    }

    /**
     * 隐藏选择框
     */
    protected void dismissPopDialog() {
        if (mPopDialog != null) {
            mPopDialog.dismiss();
        }
    }
}
