package com.xdja.im.uikit.ui.view.vu;

import android.widget.ListView;

import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;

import java.util.List;

/**
 * @Package: com.xdja.im.uikit.ui.view.adapterVu
 * @Author: xdjaxa
 * @Creation: 2017-04-19 14:59
 * @Version V1.0
 * @Description:
 */
public interface ChatListVu extends FragmentBaseView<ChatListPresenter> {

    /**
     * 设置ToolBar是否可见
     *
     * @param visibility
     */
    void setToolBarVisibility(int visibility);

    /**
     * 设置Toolbar上add功能是否可用
     *
     * @param visibility
     */
    void setToolBarAddVisibility(int visibility);

    /**
     * 设置显示
     *
     * @param title
     */
    void setTitle(String title);

    /**
     * 设置适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(ChatListAdapter adapter);

    /**
     * 设置Option数据
     *
     * @param options
     */
    void setOptions(List<OptionBean> options);

    /**
     * 获取聊天列表控件
     *
     * @return
     */
    ListView getListView();

    /**
     * 获取输入框文字信息
     *
     * @return
     */
    String getInputContent();

    /**
     * 设置文本显示信息
     *
     * @param content
     */
    void setInputContent(String content);

    /**
     * 是否正在下拉刷新中
     *
     * @return
     */
    boolean isRefreshing();

    /**
     * 停止下拉刷新
     */
    void stopRefresh();

    /**
     * 设置当前选中项<br>
     * 建议使用 setListSelection2Last
     *
     * @param selection
     */
    void setListSelection(int selection);

    /**
     * 跳转到指定位置
     *
     * @param x
     * @param y
     */
    void scrollTo(int x, int y);

    /**
     * 恢复操作面板
     */
    void restoreActionState();
    /**
     * 设置聊天类型
     */
    void setTalkType(int talkType);
}
