package com.xdja.im.uikit.utils.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;

import java.io.IOException;
import java.io.InputStream;

/**
 * @Package: com.xdja.im.uikit.utils.image
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:06
 * @Version V1.0
 * @Description:
 */
public class BitmapUtils {
    /**
     * 根据图片名称获取对应的bitmap
     *
     * @param fileName 名称
     * @param resource  资源实例
     * @return
     * @throws NoSuchFieldException
     * @throws NumberFormatException
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     */
    public static Bitmap getBitmapWithName(String fileName, Resources resource)
            throws NoSuchFieldException,
            IllegalArgumentException, IllegalAccessException {
        InputStream inputStream = null;
        try {
            inputStream = resource.getAssets().open(fileName);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream(inputStream);
    }

    /**
     * 缩小bitmap
     *
     * @param bitmap
     * @return
     */
    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale); // 长和宽放大缩小的比例
        Bitmap resizeBmp = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(),
                bitmap.getHeight(), matrix, true);
        //memory leak
        if (resizeBmp != bitmap) {
            bitmap.recycle();
        }
        return resizeBmp;
    }
}
