package com.xdja.im.uikit.utils.sys;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

/**
 * @Package: com.xdja.im.uikit.utils.sys
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:08
 * @Version V1.0
 * @Description:网络相关帮助类
 */
public class NetworkUtil {
    //-1：没有网络  1：WIFI网络2：wap网络3：net网络
    public static final int NO_CONNECT = -1;
    public static final int NET_TYPE_WIFI = 1;
    public static final int NET_TYPE_MOBILE = 2;


    /**
     * 判断是否有网络连接
     *
     * @param context 上下文
     * @return
     */
    public static boolean isNetworkConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    /**
     * 判断WIFI网络是否可用
     *
     * @param context
     * @return
     */
    public static boolean isWifiConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mWiFiNetworkInfo = mConnectivityManager
                    .getNetworkInfo(ConnectivityManager.TYPE_WIFI);
            if (mWiFiNetworkInfo != null) {
                return mWiFiNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    /**
     * 判断MOBILE网络是否可用
     *
     * @param context
     * @return
     */
    public static boolean isMobileConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mMobileNetworkInfo = mConnectivityManager
                    .getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
            if (mMobileNetworkInfo != null) {
                return mMobileNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    /**
     * 判断网络类型
     *
     * @param context 上下文
     * @return 返回值 -1：没有网络  1：WIFI网络2：wap网络3：net网络
     */
    public static int GetNetworkType(Context context) {
        int netType = NO_CONNECT;
        ConnectivityManager connMgr = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        int nType = networkInfo.getType();
        if (nType == ConnectivityManager.TYPE_MOBILE) {
            netType = NET_TYPE_MOBILE;
        } else if (nType == ConnectivityManager.TYPE_WIFI) {
            netType = NET_TYPE_WIFI;
        }
        return netType;
    }

    /**
     * Wifi连接
     *
     * @return
     */
    public static boolean isConnectByWifi(Context context) {
        return GetNetworkType(context) == NET_TYPE_WIFI;
    }

    /**
     * 手机网络连接
     *
     * @return
     */
    public static boolean isConnectByMobile(Context context) {
        return GetNetworkType(context) == NET_TYPE_MOBILE;
    }
}
