package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-05-12 18:11
 * @Version V1.0
 * @Description:圆形进度条
 */
public class CircleProgressBar extends View {

    public static final int DEFAULT_COLOR = 0x73FFFFFF;

    private int mColor;
    /**
     * circle mRadius
     */
    private int mRadius = -1;
    /**
     * mMax mProgress
     */
    private int mMax = 100;

    /**
     * current mProgress
     */
    private int mProgress = -1;

    private final Paint paint = new Paint();

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressBarStyle);
        int count = array.getIndexCount();
        for (int i = 0; i < count; i++) {
            int attr = array.getIndex(i);
            if (attr == R.styleable.CircleProgressBarStyle_color) {
                mColor = array.getColor(attr, DEFAULT_COLOR);

            } else if (attr == R.styleable.CircleProgressBarStyle_radius) {
                mRadius = array.getDimensionPixelSize(attr, -1);

            } else if (attr == R.styleable.CircleProgressBarStyle_max) {
                mMax = array.getInteger(attr, 100);

            }
        }
        array.recycle();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (mRadius != -1 && getVisibility() == VISIBLE) {
            paint.setAntiAlias(true);

            float angle = 0;
            if (mMax > 0 && mProgress >= 0) {
                angle = (float) mProgress / (float) mMax * 360f;
            }
            paint.setColor(mColor);
            @SuppressLint("DrawAllocation")
            RectF oval2 = new RectF(((float) getWidth() - mRadius * 2f) / 2f,
                    ((float) getHeight() - mRadius * 2f) / 2f,
                    (float) getWidth() - ((float) getWidth() - mRadius * 2f) / 2f,
                    (float) getHeight() - ((float) getHeight() - mRadius * 2f) / 2f);
            canvas.drawArc(oval2, 270, angle, true, paint);
        }

    }

    @Override
    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == VISIBLE) {
            invalidate();
        }
    }

    /**
     * set mMax mProgress value
     *
     * @param mMax 最大进度
     */
    public void setMax(int mMax) {
        this.mMax = mMax;
    }

    /**
     * set mProgress value
     *
     * @param mProgress 进度
     */
    public void setProgress(int mProgress) {
        this.mProgress = mProgress;
        invalidate();
    }
}
