/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.client;

import com.xdja.http.HeaderElement;
import com.xdja.http.HttpResponse;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.conn.ConnectionKeepAliveStrategy;
import com.xdja.http.message.BasicHeaderElementIterator;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

