/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.protocol;

import com.xdja.http.HttpException;
import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseInterceptor;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.io.IOException;

@Immutable
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

