/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.model;

import com.xdja.imsdk.model.body.IMMessageBody;
import com.xdja.imsdk.util.ToolUtils;

public class IMMessage {
    private long messageId;
    private String from;
    private String cardId;
    private String to;
    private int type;
    private int state;
    private long messageTime;
    private int timeToLive;
    private int failCode;
    private IMMessageBody messageBody;

    public IMMessage() {
    }

    public IMMessage(String to, int type, IMMessageBody messageBody) {
        this.to = to;
        this.type = type;
        this.messageBody = messageBody;
    }

    public long getIMMessageId() {
        return this.messageId;
    }

    public void setIMMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getCardId() {
        return this.cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getIMMessageTime() {
        return this.messageTime;
    }

    public void setIMMessageTime(long messageTime) {
        this.messageTime = messageTime;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getFailCode() {
        return this.failCode;
    }

    public void setFailCode(int failCode) {
        this.failCode = failCode;
    }

    public IMMessageBody getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(IMMessageBody messageBody) {
        this.messageBody = messageBody;
    }

    public boolean isBomb() {
        return this.state == 4;
    }

    public boolean isRead() {
        return this.state == 3;
    }

    public boolean isTextIMMessage() {
        return (this.type & 1) == 1;
    }

    public boolean isFileIMMessage() {
        return (this.type & 2) == 2;
    }

    public boolean isWebIMMessage() {
        return (this.type & 0x40) == 64;
    }

    public boolean isGroupIMMessage() {
        return (this.type & 4) == 4;
    }

    public boolean isBombIMMessage() {
        return (this.type & 8) == 8;
    }

    public boolean isReadBomb() {
        return this.isRead() && this.isBombIMMessage();
    }

    public boolean isRecalled() {
        return this.state == 5;
    }

    public boolean isATMessage() {
        return this.type == 261 || this.type == 269;
    }

    public boolean isServiceMessage() {
        return this.type == 513 || this.type == 514;
    }

    public boolean isNotice() {
        return this.type == 32769 || this.type == 32773;
    }

    public boolean isCustom() {
        return this.type == 65541 || this.type == 65537;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "IMMessage{messageId=" + this.messageId + ", from='" + this.from + '\'' + ", cardId='" + this.cardId + '\'' + ", to='" + this.to + '\'' + ", type=" + this.type + ", state=" + this.state + ", messageTime=" + ToolUtils.getFormatTime(this.messageTime) + ", timeToLive=" + this.timeToLive + ", failCode=" + this.failCode + ", messageBody=" + this.messageBody + '}';
    }
}

