/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.os.SystemClock;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.model.IMMessage;
import java.io.File;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ToolUtils {
    private static final char[] PWDCHARS_ARRAY = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static boolean isEmpty(String str) {
        return TextUtils.isEmpty((CharSequence)str);
    }

    public static String pushTopic(String cardId) {
        return "xdja/d/" + cardId + "/im";
    }

    public static String pushClientId(String cardId) {
        return "xdja/d/" + cardId;
    }

    public static String getSessionTag(String account, int sessionType) {
        return String.valueOf(account) + "_" + sessionType;
    }

    public static String getSessionTag(String tag, IMMessage message) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            return tag;
        }
        int sessionType = 1;
        if (message.isGroupIMMessage()) {
            sessionType = 2;
        } else if (message.isServiceMessage()) {
            sessionType = 100;
        }
        return ToolUtils.getSessionTag(message.getTo(), sessionType);
    }

    public static String getLastString(String input, String separator) {
        if (input == null) {
            return null;
        }
        if (input.equals("")) {
            return "";
        }
        if (separator == null || "".equals(separator)) {
            return "";
        }
        int cursor = 0;
        int lastPos = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((cursor = input.indexOf(separator, cursor)) != -1) {
            String token = input.substring(lastPos, cursor);
            list.add(token);
            cursor = lastPos = cursor + separator.length();
        }
        if (lastPos == 0) {
            return "";
        }
        if (lastPos < input.length()) {
            list.add(input.substring(lastPos));
        }
        if (list.size() == 0) {
            return "";
        }
        return (String)list.get(list.size() - 1);
    }

    public static int getPos(String s, String separator) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)separator)) {
            return 0;
        }
        int cursor = 0;
        int lastPos = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((cursor = s.indexOf(separator, cursor)) != -1) {
            String token = s.substring(lastPos, cursor);
            list.add(token);
            cursor = lastPos = cursor + separator.length();
        }
        return lastPos;
    }

    public static String subString(String s, String sub) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        if (TextUtils.isEmpty((CharSequence)sub)) {
            return s;
        }
        String last = ToolUtils.getLastString(s, ".");
        int pos = ToolUtils.getPos(s, ".");
        if (sub.equals(last) && pos > 0) {
            return s.substring(0, pos - 1);
        }
        return s;
    }

    public static String toMD5(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(content.getBytes("UTF-8"));
            if (hash == null || hash.length == 0) {
                return content;
            }
            StringBuilder hex = new StringBuilder(hash.length * 2);
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
                ++n2;
            }
            return hex.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    public static int getInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static long getLong(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getLong(Long id) {
        if (id == null) {
            return -1L;
        }
        return id;
    }

    public static long getTimeDistance(long currentTime) {
        return currentTime * 1000000L - SystemClock.elapsedRealtimeNanos();
    }

    public static long getMTime(long nTime) {
        if (String.valueOf(nTime).length() == 19) {
            return nTime / 1000000L;
        }
        return nTime;
    }

    public static boolean isImageSuffix(String suffix) {
        return suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg") || suffix.equalsIgnoreCase("png") || suffix.equalsIgnoreCase("bmp");
    }

    public static String encode(String source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return "";
        }
        byte[] bytes = source.getBytes();
        int len = bytes.length;
        StringBuffer encoded = new StringBuffer((len + 2) / 3 * 4);
        int i = 0;
        int j = len;
        while (j >= 3) {
            encoded.append(ToolUtils.to64((bytes[i] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF, 4));
            i += 3;
            j -= 3;
        }
        if (j == 2) {
            encoded.append(ToolUtils.to64((bytes[i] & 0xFF) << 8 | bytes[i + 1] & 0xFF, 3));
        }
        if (j == 1) {
            encoded.append(ToolUtils.to64(bytes[i] & 0xFF, 2));
        }
        return encoded.toString();
    }

    public static String decode(String string2) {
        int l;
        long d;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        byte[] encoded = string2.getBytes();
        int len = encoded.length;
        byte[] decoded = new byte[len * 3 / 4];
        int i = 0;
        int j = len;
        int k = 0;
        while (j >= 4) {
            d = ToolUtils.from64(encoded, i, 4);
            j -= 4;
            i += 4;
            l = 2;
            while (l >= 0) {
                decoded[k + l] = (byte)(d & 0xFFL);
                d >>= 8;
                --l;
            }
            k += 3;
        }
        if (j == 3) {
            d = ToolUtils.from64(encoded, i, 3);
            l = 1;
            while (l >= 0) {
                decoded[k + l] = (byte)(d & 0xFFL);
                d >>= 8;
                --l;
            }
        }
        if (j == 2) {
            d = ToolUtils.from64(encoded, i, 2);
            decoded[k] = (byte)(d & 0xFFL);
        }
        return new String(decoded);
    }

    private static String to64(long input, int size) {
        StringBuffer result = new StringBuffer(size);
        while (size > 0) {
            --size;
            result.append(PWDCHARS_ARRAY[(int)(input & 0x3FL)]);
            input >>= 6;
        }
        return result.toString();
    }

    private static long from64(byte[] encoded, int idx, int size) {
        long res = 0L;
        int f = 0;
        while (size > 0) {
            byte d;
            --size;
            long r = 0L;
            if ((d = encoded[idx++]) == 47) {
                r = 1L;
            }
            if (d >= 48 && d <= 57) {
                r = 2 + d - 48;
            }
            if (d >= 65 && d <= 90) {
                r = 12 + d - 65;
            }
            if (d >= 97 && d <= 122) {
                r = 38 + d - 97;
            }
            res += r << f;
            f += 6;
        }
        return res;
    }

    public static boolean fileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static boolean mkFile(String path) {
        File dest = new File(path);
        File dir = dest.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            Logger.getLogger().d("ImSdk create directory fail...");
            return false;
        }
        return true;
    }

    public static boolean initFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return false;
    }

    public static String getFormatTime(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(new Date(time));
    }

    public static String getFormatContent(String content) {
        if (Logger.getLogger().debug()) {
            if (TextUtils.isEmpty((CharSequence)content)) {
                return "";
            }
            if (content.length() < 10) {
                return content;
            }
            return String.valueOf(content.substring(0, 10)) + "...";
        }
        return content;
    }

    public static String getFormatLastContent(String content) {
        if (Logger.getLogger().debug()) {
            if (TextUtils.isEmpty((CharSequence)content)) {
                return "";
            }
            if (content.length() < 10) {
                return content;
            }
            return String.valueOf(content.substring(content.length() - 10, content.length())) + "...";
        }
        return content;
    }
}

