/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley;

import com.xdja.imsdk.volley.RetryPolicy;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.VolleyError;

public class CustomRetryPolicy
implements RetryPolicy {
    private final int mInitialTimeoutMs;
    private int mCurrentTimeoutMs;
    private int mCurrentRetryCount;
    private int mEclipseTimeoutMs;
    public static final int DEFAULT_TIMEOUT_MS = 5000;
    public static final int DEFAULT_MAX_RETRIES = 1;

    public CustomRetryPolicy() {
        this(5000, 5000);
    }

    public CustomRetryPolicy(int initialTimeoutMs, int currentTimeoutMs) {
        if (currentTimeoutMs <= 0 || initialTimeoutMs <= 0) {
            currentTimeoutMs = 5000;
            initialTimeoutMs = 5000;
        }
        this.mInitialTimeoutMs = initialTimeoutMs;
        this.mCurrentTimeoutMs = currentTimeoutMs;
    }

    @Override
    public int getCurrentTimeout() {
        return this.mCurrentTimeoutMs;
    }

    @Override
    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }

    @Override
    public void retry(VolleyError error, long expendTimeMs) throws VolleyError {
        ++this.mCurrentRetryCount;
        this.mEclipseTimeoutMs = (int)((long)this.mEclipseTimeoutMs + expendTimeMs);
        VolleyLog.d("init timeout " + this.mInitialTimeoutMs + " ms, currently elapsed time " + this.mEclipseTimeoutMs + " ms and retry count " + this.mCurrentRetryCount, new Object[0]);
        if (!this.hasAttemptRemaining()) {
            throw error;
        }
    }

    @Override
    public int getElapsedTimeTimeoutMs() {
        return this.mEclipseTimeoutMs;
    }

    @Override
    public int getInitialTimeoutMs() {
        return this.mInitialTimeoutMs;
    }

    @Override
    public boolean hasAttemptRemaining() {
        return this.mEclipseTimeoutMs < this.mInitialTimeoutMs;
    }
}

