/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.request;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.volley.CustomRetryPolicy;
import com.xdja.imsdk.volley.RequestQueue;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.AuthFailureError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.request.JsonObjectRequest;
import com.xdja.imsdk.volley.request.RequestInfo;
import com.xdja.imsdk.volley.request.StringRequest;
import com.xdja.imsdk.volley.request.UploadRequest;
import com.xdja.imsdk.volley.stack.HttpClientStack;
import com.xdja.imsdk.volley.stack.HttpsStackUtil;
import com.xdja.imsdk.volley.toolbox.FileDownloader;
import com.xdja.imsdk.volley.toolbox.FileUploader;
import com.xdja.imsdk.volley.toolbox.HttpCallback;
import com.xdja.imsdk.volley.toolbox.Volley;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class RequestManager {
    public static final int FILE_DOWNLOAD_TASK_COUNT = 2;
    public static final int FILE_UPLOAD_TASK_COUNT = 1;
    private Context mContext;
    private RequestQueue mRequestQueue;
    private RequestQueue mUploadRequestQueue;
    private RequestQueue mDownloadRequestQueue;
    private FileDownloader mFileDownloader;
    private FileUploader mFileUploader;
    boolean isHttpsRequest = false;

    private RequestManager() {
    }

    public static RequestManager getInstance() {
        return RequestManagerInstance.mInstance;
    }

    public void init(Context context, boolean isHttps, int keyStore, String pwd) {
        this.mContext = context;
        this.isHttpsRequest = isHttps;
        this.mRequestQueue = !this.isHttpsRequest ? Volley.newRequestQueue() : Volley.newRequestQueue(HttpsStackUtil.getHttpsStack(this.mContext, keyStore, pwd), 0);
        this.mUploadRequestQueue = Volley.newRequestQueue(new HttpClientStack(), 1);
        this.mFileUploader = new FileUploader(this.mUploadRequestQueue, 1);
        this.mDownloadRequestQueue = Volley.newRequestQueue(2);
        this.mFileDownloader = new FileDownloader(this.mDownloadRequestQueue, 2);
    }

    private void initUploadQueue() {
        if (this.mUploadRequestQueue == null) {
            this.mUploadRequestQueue = Volley.newRequestQueue(new HttpClientStack(), 1);
        }
        if (this.mFileUploader == null) {
            this.mFileUploader = new FileUploader(this.mUploadRequestQueue, 1);
        }
    }

    private void initDownloadQueue() {
        if (this.mDownloadRequestQueue == null) {
            this.mDownloadRequestQueue = Volley.newRequestQueue(2);
        }
        if (this.mFileDownloader == null) {
            this.mFileDownloader = new FileDownloader(this.mDownloadRequestQueue, 2);
        }
    }

    public void get(String url, Map<String, String> paramsMap, HttpCallback httpResult) {
        this.get(new RequestInfo(url, paramsMap), httpResult);
    }

    public void get(RequestInfo requestInfo, HttpCallback httpResult) {
        this.sendRequest(0, requestInfo, httpResult);
    }

    public void post(String url, Map<String, String> paramsMap, HttpCallback httpResult) {
        this.post(new RequestInfo(url, paramsMap), httpResult);
    }

    public void post(RequestInfo requestInfo, HttpCallback httpResult) {
        this.sendRequest(1, requestInfo, httpResult);
    }

    public void post(String url, JSONObject object, HttpCallback httpResult) {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        this.post(requestInfo, object, httpResult);
    }

    public void post(RequestInfo requestInfo, JSONObject object, HttpCallback httpResult) {
        this.sendJsonRequest(1, requestInfo, object, httpResult);
    }

    public void post(HttpApiConstant.IMRequestType type, RequestInfo requestInfo, JSONObject object, HttpCallback httpResult) {
        int method = 1;
        if (type == HttpApiConstant.IMRequestType.STATE) {
            method = 2;
        }
        this.sendJsonRequest(method, requestInfo, object, httpResult);
    }

    public void post(String url, JSONArray object, HttpCallback httpResult) {
    }

    public void delete(RequestInfo requestInfo, HttpCallback httpResult) {
        this.sendRequest(3, requestInfo, httpResult);
    }

    public void put(RequestInfo requestInfo, HttpCallback httpResult) {
        this.sendRequest(2, requestInfo, httpResult);
    }

    public void uploadFileStart(String url, String filePath, String requestTag, CustomRetryPolicy policy, HttpCallback callback) {
        if (this.mFileUploader == null) {
            this.initUploadQueue();
        }
        this.mFileUploader.add(url, filePath, requestTag, policy, callback);
    }

    public void uploadFileResume(String tag) {
        FileUploader.UploadController controller;
        if (this.mFileUploader == null) {
            this.initUploadQueue();
        }
        if ((controller = this.mFileUploader.get(tag)) != null) {
            controller.resume();
        } else {
            VolleyLog.d("controller is null.", new Object[0]);
        }
    }

    public void uploadFilePause(String tag) {
        FileUploader.UploadController controller;
        if (this.mFileUploader == null) {
            this.initUploadQueue();
        }
        if ((controller = this.mFileUploader.get(tag)) != null) {
            controller.pause();
        }
    }

    public void uploadFileStop(String tag) {
        FileUploader.UploadController controller;
        if (this.mFileUploader == null) {
            this.initUploadQueue();
        }
        if ((controller = this.mFileUploader.get(tag)) != null) {
            controller.stop();
        }
    }

    public void downloadFile(String url, String target, long fileSize, HttpCallback callback) {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        this.downloadFile(requestInfo, target, fileSize, callback);
    }

    public void downloadFile(RequestInfo requestInfo, String target, long fileSize, HttpCallback callback) {
        FileDownloader.DownloadController controller;
        if (this.mFileDownloader == null) {
            this.initDownloadQueue();
        }
        if ((controller = this.mFileDownloader.get(requestInfo.url)) == null) {
            this.mFileDownloader.add(requestInfo.url, target, requestInfo.tag, fileSize, requestInfo.isSupportRange, requestInfo.retryPolicy, callback);
        } else if (controller.isPause()) {
            controller.resume();
        }
    }

    public void downloadFileResume(String url, String target, long fileSize, HttpCallback callback) {
        FileDownloader.DownloadController controller;
        if (this.mFileDownloader == null) {
            this.initDownloadQueue();
        }
        if ((controller = this.mFileDownloader.get(url)) != null) {
            controller.resume();
        } else {
            this.downloadFile(url, target, fileSize, callback);
        }
    }

    public void downloadFilePause(String url, String tag) {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        this.downloadFilePause(requestInfo, tag);
    }

    public void downloadFilePause(RequestInfo requestInfo, String tag) {
        FileDownloader.DownloadController controller;
        if (this.mFileDownloader == null) {
            this.initDownloadQueue();
        }
        if ((controller = this.mFileDownloader.get(requestInfo.url)) != null) {
            controller.pause(tag);
        }
    }

    public void downloadFileStop(String url, String target) {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        this.downloadFileStop(requestInfo, target);
    }

    public void downloadFileStop(RequestInfo requestInfo, String target) {
        FileDownloader.DownloadController controller;
        if (this.mFileDownloader == null) {
            this.initDownloadQueue();
        }
        if ((controller = this.mFileDownloader.get(requestInfo.url)) != null) {
            controller.stop();
        }
    }

    private void sendRequest(final int method, final RequestInfo requestInfo, final HttpCallback httpResult) {
        if (httpResult != null) {
            httpResult.onStart();
        }
        if (requestInfo == null || TextUtils.isEmpty((CharSequence)requestInfo.url)) {
            if (httpResult != null) {
                httpResult.onStart();
                httpResult.onError(new VolleyError("url can not be empty!"));
            }
            return;
        }
        switch (method) {
            case 0: {
                requestInfo.url = requestInfo.getFullUrl();
                break;
            }
            case 3: {
                requestInfo.url = requestInfo.getFullUrl();
                break;
            }
        }
        StringRequest request = new StringRequest(method, requestInfo.url, new Response.Listener<String>(){

            @Override
            public void onResponse(String response) {
                if (httpResult != null) {
                    httpResult.onResult(response);
                    httpResult.onFinish();
                }
            }
        }, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (httpResult != null) {
                    httpResult.onError(error);
                    httpResult.onFinish();
                }
            }
        }, new Response.LoadingListener(){

            @Override
            public void onLoading(long count, long current) {
            }
        }){

            @Override
            protected Map<String, String> getParams() throws AuthFailureError {
                if (method == 1 || method == 2) {
                    VolleyLog.d(method == 1 ? "post->%s" : "put->%s", String.valueOf(requestInfo.getUrl()) + ",params->" + requestInfo.getParams().toString());
                    return requestInfo.getParams();
                }
                return super.getParams();
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return requestInfo.getHeaders();
            }
        };
        request.setTag(this);
        if (this.mRequestQueue == null) {
            return;
        }
        this.mRequestQueue.add(request);
    }

    public void sendJsonRequest(int method, final RequestInfo requestInfo, JSONObject object, final HttpCallback httpResult) {
        if (httpResult != null) {
            httpResult.onStart();
        }
        if (TextUtils.isEmpty((CharSequence)requestInfo.url)) {
            if (httpResult != null) {
                httpResult.onStart();
                httpResult.onError(new VolleyError("url can not be empty!"));
            }
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(method, requestInfo.url, object, new Response.Listener<JSONObject>(){

            @Override
            public void onResponse(JSONObject response) {
                if (httpResult != null) {
                    httpResult.onResult(response.toString());
                    httpResult.onFinish();
                }
            }
        }, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.d("send json request error:" + (error == null ? " " : error.getMessage()), new Object[0]);
                if (httpResult != null) {
                    httpResult.onError(error);
                }
            }
        }){

            @Override
            public void cancel() {
                super.cancel();
                if (httpResult != null) {
                    httpResult.onCanceled();
                }
            }

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return requestInfo.getHeaders();
            }

            @Override
            public void onNetChange(int code, String message) {
                super.onNetChange(code, message);
                if (httpResult != null) {
                    httpResult.onNetChanged(code, message);
                }
            }
        };
        request.setRetryPolicy(requestInfo.retryPolicy);
        request.setTag(requestInfo.tag);
        if (this.mRequestQueue == null) {
            return;
        }
        this.mRequestQueue.add(request);
    }

    public void sendFidRequest(String url, String fileName, String requestTag, CustomRetryPolicy retryPolicy, final HttpCallback httpResult) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)fileName)) {
            if (httpResult != null) {
                httpResult.onStart();
                httpResult.onError(new VolleyError("params error!"));
            }
            return;
        }
        if (httpResult != null) {
            httpResult.onStart();
        }
        UploadRequest request = new UploadRequest(1, url, new Response.Listener(){

            public void onResponse(Object response) {
                if (httpResult != null) {
                    httpResult.onResult(response.toString());
                    httpResult.onFinish();
                }
            }
        }, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (httpResult != null) {
                    httpResult.onError(error);
                }
            }
        }, new Response.LoadingListener(){

            @Override
            public void onLoading(long count, long current) {
            }
        }){

            @Override
            public void onNetChange(int code, String message) {
                super.onNetChange(code, message);
                if (httpResult != null) {
                    httpResult.onNetChanged(code, message);
                }
            }
        };
        request.setRetryPolicy(retryPolicy);
        request.setFileFid(fileName);
        request.setTag(requestTag);
        this.mUploadRequestQueue.add(request);
    }

    public void cancelRequest(String tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll(tag);
        }
        if (this.mUploadRequestQueue != null) {
            this.mUploadRequestQueue.cancelAll(tag);
        }
        if (this.mDownloadRequestQueue != null) {
            this.mDownloadRequestQueue.cancelAll(tag);
        }
        if (this.mFileUploader != null) {
            this.mFileUploader.cancel(tag);
        }
        if (this.mFileDownloader != null) {
            this.mFileDownloader.cancel(tag);
        }
    }

    public void cancelAll() {
        VolleyLog.e("exit...", new Object[0]);
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll();
            this.mRequestQueue.stop();
            this.mRequestQueue = null;
        }
        if (this.mUploadRequestQueue != null) {
            this.mUploadRequestQueue.cancelAll();
            this.mUploadRequestQueue.stop();
            this.mUploadRequestQueue = null;
        }
        if (this.mDownloadRequestQueue != null) {
            this.mDownloadRequestQueue.cancelAll();
            this.mDownloadRequestQueue.stop();
            this.mDownloadRequestQueue = null;
        }
        if (this.mFileUploader != null) {
            this.mFileUploader.clearAll();
            this.mFileUploader = null;
        }
        if (this.mFileDownloader != null) {
            this.mFileDownloader.clearAll();
            this.mFileDownloader = null;
        }
        HttpClientStack.release();
    }

    /* synthetic */ RequestManager(RequestManager requestManager) {
        this();
    }

    private static class RequestManagerInstance {
        private static final RequestManager mInstance = new RequestManager(null);

        private RequestManagerInstance() {
        }
    }
}

