/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.frame.presenter;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.PagerAdapterView;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BasePagerAdapterPresenter<P extends Presenter, D>
extends PagerAdapter {
    public Map<Integer, BaseFilePreview> adapterVus = new ConcurrentHashMap<Integer, BaseFilePreview>();

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        PagerAdapterView<P, D> adapterVu = null;
        View convertView = null;
        int itemViewType = this.getItemViewType(position);
        Class<PagerAdapterView<P, D>> aClass = this.getVuClassByViewType(itemViewType);
        try {
            if (aClass == null) {
                throw new NullPointerException("item view type error!");
            }
            adapterVu = aClass.newInstance();
            adapterVu.setPresenter(this.getPresenter());
            adapterVu.setActivity(this.getActivity());
            adapterVu.init(LayoutInflater.from((Context)container.getContext()), container);
            convertView = adapterVu.getView();
            container.addView(convertView);
            adapterVu.bindDataSource(position, this.getDataSource(position));
            this.adapterVus.put(position, (BaseFilePreview)adapterVu);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        this.adapterVus.remove(position);
        PagerAdapterView adapterVu = null;
        adapterVu = this.adapterVus.get(position);
        if (adapterVu != null) {
            adapterVu.onViewDestroy();
        }
    }

    public abstract int getItemViewType(int var1);

    protected abstract List<Class<? extends PagerAdapterView<P, D>>> getVuClasses();

    protected abstract P getPresenter();

    protected abstract D getDataSource(int var1);

    @NonNull
    protected Class<? extends PagerAdapterView<P, D>> getVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null && itemViewType < this.getVuClasses().size()) {
            return this.getVuClasses().get(itemViewType);
        }
        return null;
    }

    protected Activity getActivity() {
        return null;
    }

    public abstract void onPageSelected(int var1, int var2);
}

