/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.xdja.im.common.database.DBContext;
import com.xdja.im.common.database.DatabaseHelper;

public class DatabaseManager {
    private static final String DATABASE_NAME = "imuikit.db";
    private static final int DATABASE_VERSION = 1;
    private DatabaseHelper dbHelper;

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return SingletonInstance.mInstance;
    }

    public void initDatabase(Context context, String account) {
        DatabaseManager.getInstance().dbHelper = new DatabaseHelper(new DBContext(context, account), DATABASE_NAME, null, 1);
    }

    public synchronized SQLiteDatabase getDatabase() {
        if (this.dbHelper == null) {
            throw new RuntimeException("database already closed...");
        }
        return this.dbHelper.getReadableDatabase();
    }

    public synchronized void close() {
        if (this.dbHelper != null) {
            this.dbHelper.close();
        }
        this.dbHelper = null;
    }

    private static class SingletonInstance {
        private static final DatabaseManager mInstance = new DatabaseManager();

        private SingletonInstance() {
        }
    }
}

