/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.view;

import android.graphics.Color;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.ui.adapter.ImagePickerAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePickerPresenter;
import com.xdja.im.lib.album.ui.view.vu.ImagePickerVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;

public class ViewImagePicker
extends ImActivitySuperView<ImagePickerPresenter>
implements ImagePickerVu {
    private RelativeLayout mContainerLayout;
    private RecyclerView mAlbumListRv;
    private Button mPreviewBtn;
    private Button mSendBtn;
    private LinearLayout mEmptyLayout;
    private RelativeLayout mBottomLayout;
    private ProgressBar mLoadingPBar;
    private int mColumnNum;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_image_picker;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_selest_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.initView();
        this.mColumnNum = ImagePickerManager.getInstance().getConfig().getColumnNum();
        this.mAlbumListRv.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.mColumnNum));
        this.mPreviewBtn.setEnabled(false);
        this.mSendBtn.setEnabled(false);
        this.mSendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ImagePickerPresenter)ViewImagePicker.this.getPresenter()).sendImage(ImageDataSource.getInstance().getSelects());
            }
        });
        this.mPreviewBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ImagePickerPresenter)ViewImagePicker.this.getPresenter()).preView();
            }
        });
    }

    private void initView() {
        this.mContainerLayout = (RelativeLayout)this.findViewById(R.id.layout_container);
        this.mAlbumListRv = (RecyclerView)this.findViewById(R.id.rv_album_list);
        this.mPreviewBtn = (Button)this.findViewById(R.id.btn_preview);
        this.mSendBtn = (Button)this.findViewById(R.id.btn_send);
        this.mEmptyLayout = (LinearLayout)this.findViewById(R.id.layout_album_empty);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.layout_bottom);
    }

    @Override
    public void setAdapter(ImagePickerAdapter adapter) {
        this.mAlbumListRv.setAdapter((RecyclerView.Adapter)adapter);
        adapter.notifyDataSetChanged();
        this.mAlbumListRv.setVisibility(0);
        this.mEmptyLayout.setVisibility(8);
    }

    @Override
    public void setEmptyLayoutVisible() {
        this.mEmptyLayout.setVisibility(0);
        this.mAlbumListRv.setVisibility(8);
        this.mContainerLayout.setVisibility(8);
        this.mBottomLayout.setVisibility(8);
    }

    @Override
    public void refreshSelectPictureIndicator() {
        int selectCnt = ImageDataSource.getInstance().size();
        if (selectCnt > 0) {
            this.mSendBtn.setClickable(true);
            this.mPreviewBtn.setClickable(true);
            this.mSendBtn.setEnabled(true);
            this.mPreviewBtn.setEnabled(true);
            ViewGroup.LayoutParams params = this.mSendBtn.getLayoutParams();
            params.width = -2;
            this.mSendBtn.setLayoutParams(params);
            this.mSendBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_picture_send_indicator), selectCnt, 9));
            this.mSendBtn.setTextColor(Color.parseColor((String)"#F3000000"));
            this.mPreviewBtn.setTextColor(Color.parseColor((String)"#F3000000"));
        } else {
            ViewGroup.LayoutParams params = this.mSendBtn.getLayoutParams();
            params.width = (int)TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
            this.mSendBtn.setLayoutParams(params);
            this.mSendBtn.setText(R.string.im_uikit_send);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#77000000"));
            this.mPreviewBtn.setTextColor(Color.parseColor((String)"#77000000"));
            this.mSendBtn.setEnabled(false);
            this.mPreviewBtn.setEnabled(false);
            this.mSendBtn.setClickable(false);
            this.mPreviewBtn.setClickable(false);
        }
    }

    @Override
    public void setProgressBarVisible(boolean bVisible) {
        this.mLoadingPBar.setVisibility(bVisible ? 0 : 8);
    }
}

