/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.manager;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Chronometer;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.R;

public class DialogManager {
    private ImageView mIcon;
    private ImageView mVoice;
    public TextView mLabel;
    public Chronometer mVoiceChronometer;
    private final Context mContext;
    private Dialog dialog;

    public DialogManager(Context context) {
        this.mContext = context;
    }

    public void showRecordingDialog() {
        if (this.dialog == null) {
            this.dialog = new Dialog(this.mContext, R.style.im_uikit_AudioDialog);
        }
        this.dialog.setCancelable(false);
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View view = inflater.inflate(R.layout.im_uikit_recorder_dialog, null);
        this.mIcon = (ImageView)view.findViewById(R.id.id_recorder_dialog_icon);
        this.mVoice = (ImageView)view.findViewById(R.id.id_recorder_dialog_voice);
        this.mLabel = (TextView)view.findViewById(R.id.id_recorder_dialog_label);
        this.mVoiceChronometer = (Chronometer)view.findViewById(R.id.id_recorder_Chronometer);
        this.dialog.setContentView(view);
        this.dialog.show();
    }

    public void recording() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.mIcon.setVisibility(0);
            this.mVoice.setVisibility(0);
            this.mLabel.setVisibility(0);
            this.mIcon.setImageResource(R.mipmap.im_uikit_ic_message_vioce);
            this.mLabel.setText(R.string.im_uikit_slide_to_cancel);
        }
    }

    public void wantToCancel() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.mIcon.setVisibility(0);
            this.mVoice.setVisibility(8);
            this.mLabel.setVisibility(0);
            this.mIcon.setImageResource(R.mipmap.im_uikit_ic_message_cancel);
            this.mLabel.setText(R.string.im_uikit_cancel_send);
        }
    }

    public void lastTenSeconds(String str) {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.mIcon.setVisibility(8);
            this.mVoice.setVisibility(8);
            this.mLabel.setVisibility(0);
            this.mLabel.setText((CharSequence)str);
        }
    }

    public void tooShort() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.mIcon.setVisibility(0);
            this.mVoice.setVisibility(8);
            this.mLabel.setVisibility(0);
            this.mIcon.setImageResource(R.mipmap.im_uikit_recording_voice_too_short);
            this.mLabel.setText(R.string.im_uikit_record_too_short);
        }
    }

    public void tooShort(Context context) {
        if (this.dialog != null) {
            CommonTool.showToast(R.string.im_uikit_record_too_short);
        }
    }

    public void tooShortToShow(Context context) {
        CommonTool.showToast(R.string.im_uikit_record_too_short);
    }

    public void getAudioDeviceErrToShow(Context context) {
        CommonTool.showToast(R.string.im_uikit_obtion_audio_device_err);
    }

    public void getAudioPermissionErrToShow(Context context) {
        CommonTool.showToast(R.string.im_uikit_gaint_audio_permission_err);
    }

    public void dismissDialog() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    public void updateVoiceLevel(int level) {
        if (this.dialog != null && this.dialog.isShowing()) {
            int resId = this.mContext.getResources().getIdentifier("im_uikit_v" + level, "mipmap", this.mContext.getPackageName());
            this.mVoice.setImageResource(resId);
        }
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }
}

