/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.camera.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.xdja.im.lib.camera.utils.ProviderUtil;
import com.xdja.im.lib.camera.utils.ToolUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CameraHelper {
    public static final String PATH_DCIM = "/DCIM/camera/";
    private static File mTakePhotoFile;
    private static final int CAMERA_ID = 0;

    public static void takePhoto(Activity activity, int requestCode) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("orientation", 0);
        intent.addFlags(1);
        if (intent.resolveActivity(activity.getPackageManager()) != null) {
            Uri uri;
            mTakePhotoFile = CameraHelper.createFile("IMG_", ".jpg");
            if (mTakePhotoFile == null) {
                return;
            }
            if (Build.VERSION.SDK_INT < 23) {
                uri = Uri.fromFile((File)mTakePhotoFile);
            } else {
                File imageRootPath = ToolUtils.isSdCardExist() ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES) : Environment.getDataDirectory();
                File mediaStorageDir = new File(imageRootPath, PATH_DCIM);
                if (!mediaStorageDir.exists()) {
                    mediaStorageDir.mkdirs();
                }
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                mTakePhotoFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
                try {
                    if (mTakePhotoFile.exists()) {
                        mTakePhotoFile.delete();
                    }
                    mTakePhotoFile.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                uri = FileProvider.getUriForFile((Context)activity, (String)ProviderUtil.getFileProviderName((Context)activity), (File)mTakePhotoFile);
                List resInfoList = activity.getPackageManager().queryIntentActivities(intent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, uri, 3);
                }
            }
            intent.putExtra("output", (Parcelable)uri);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static File createFile(String prefix, String suffix) {
        String imageRootPath = ToolUtils.isSdCardExist() ? Environment.getExternalStorageDirectory() + PATH_DCIM : Environment.getDataDirectory().getAbsolutePath() + PATH_DCIM;
        File imgRootPath = new File(imageRootPath);
        if (!imgRootPath.exists()) {
            imgRootPath.mkdirs();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
        String filename = prefix + dateFormat.format(new Date(System.currentTimeMillis())) + suffix;
        String photoFileCachePath = imageRootPath + filename;
        return new File(photoFileCachePath);
    }

    public static void galleryAddPic(Activity activity, File file) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri contentUri = Uri.fromFile((File)file);
        mediaScanIntent.setData(contentUri);
        activity.sendBroadcast(mediaScanIntent);
    }

    public static File getTakePhotoFile() {
        return mTakePhotoFile;
    }

    public static Camera getCameraInstance(int cameraId) {
        Camera c = null;
        try {
            c = Camera.open((int)cameraId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    private void releaseCamera(Camera camera) {
        if (camera != null) {
            camera.release();
            camera = null;
        }
    }
}

