/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.xdja.im.uikit.R;

public class FocusView
extends View {
    private float defaultRadius;
    private float focusLine;
    private float centerX;
    private float centerY;
    private float radius;
    private float maxRadius;
    private int paintAlpha = 255;
    private int paintColor = -1;
    private final Rect rect = new Rect();
    private boolean isNeedDismiss = true;
    private Paint mPaint;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    FocusView.this.radius = FocusView.this.radius - 5.0f;
                    if (FocusView.this.radius <= FocusView.this.maxRadius) {
                        FocusView.this.radius = FocusView.this.radius + 5.0f;
                        FocusView.this.mHandler.sendEmptyMessageDelayed(1, 500L);
                        break;
                    }
                    FocusView.this.mHandler.sendEmptyMessageDelayed(0, (long)(FocusView.this.radius / 200.0f));
                    FocusView.this.invalidate();
                    break;
                }
                case 1: {
                    FocusView.this.paintAlpha = FocusView.this.paintAlpha - 20;
                    if (FocusView.this.paintAlpha <= 0) {
                        FocusView.this.isNeedDismiss = true;
                        FocusView.this.invalidate();
                        break;
                    }
                    FocusView.this.mPaint.setAlpha(FocusView.this.paintAlpha);
                    FocusView.this.invalidate();
                    FocusView.this.mHandler.sendEmptyMessageDelayed(1, 15L);
                    break;
                }
            }
        }
    };

    public FocusView(Context context) {
        super(context);
    }

    public FocusView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FocusView);
        int count = typedArray.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int id2 = typedArray.getIndex(i);
            if (id2 == R.styleable.FocusView_focusColor) {
                this.paintColor = typedArray.getColor(id2, -1);
                continue;
            }
            if (id2 == R.styleable.FocusView_focusDefaultRadius) {
                this.defaultRadius = typedArray.getFloat(id2, 100.0f);
                continue;
            }
            if (id2 == R.styleable.FocusView_focusMaxRadius) {
                this.maxRadius = typedArray.getFloat(id2, 40.0f);
                continue;
            }
            if (id2 != R.styleable.FocusView_focusLine) continue;
            this.focusLine = typedArray.getFloat(id2, 10.0f);
        }
        typedArray.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(3.0f);
        this.mPaint.setColor(this.paintColor);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mHandler.removeMessages(0);
                this.mHandler.removeMessages(1);
                this.invalidate();
                this.centerX = event.getX();
                this.centerY = event.getY();
                this.isNeedDismiss = false;
                this.paintAlpha = 255;
                this.mPaint.setAlpha(this.paintAlpha);
                this.radius = this.defaultRadius;
                this.mHandler.obtainMessage(0).sendToTarget();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public void setFocusCircleRadius(float radius) {
        this.radius = radius;
    }

    public void setFocusCircleMaxRadius(float radius) {
        this.maxRadius = radius;
    }

    public void setFocusCircleColor(int color2) {
        this.paintColor = color2;
        this.mPaint.setColor(color2);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isNeedDismiss) {
            this.rect.set((int)(this.centerX - this.radius), (int)(this.centerY - this.radius), (int)(this.centerX + this.radius), (int)(this.centerY + this.radius));
            canvas.drawRect(this.rect, this.mPaint);
            canvas.drawLine((float)((int)(this.centerX - this.radius)), (float)((int)this.centerY), (float)((int)(this.centerX - this.radius + this.focusLine)), (float)((int)this.centerY), this.mPaint);
            canvas.drawLine((float)((int)(this.centerX + this.radius - this.focusLine)), (float)((int)this.centerY), (float)((int)(this.centerX + this.radius)), (float)((int)this.centerY), this.mPaint);
            canvas.drawLine((float)((int)this.centerX), (float)((int)(this.centerY - this.radius)), (float)((int)this.centerX), (float)((int)(this.centerY - this.radius + this.focusLine)), this.mPaint);
            canvas.drawLine((float)((int)this.centerX), (float)((int)(this.centerY + this.radius)), (float)((int)this.centerX), (float)((int)(this.centerY + this.radius - this.focusLine)), this.mPaint);
        }
    }
}

