/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

public class ViewSendImageItem
extends BaseSendItem {
    private ChatImageView mChatImage;
    private ImageView mBombFlagImg;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_send_image);
        this.mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendImageItem.this.getPresenter()).previewImage((TalkMessageBean)ViewSendImageItem.this.dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }
        this.loadImage(fileInfo.getFilePath());
        if (dataSource.isBomb()) {
            this.mBombFlagImg.setVisibility(0);
        }
    }

    private void loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            this.mChatImage.loadImage(filePath);
        } else {
            LogUtil.w("file is not exit.");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }
}

