/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.model.message.mapper;

import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.message.mapper.ValueConverter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMImageBody;
import com.xdja.imsdk.model.body.IMMessageBody;
import com.xdja.imsdk.model.body.IMNormalFileBody;
import com.xdja.imsdk.model.body.IMRecallBody;
import com.xdja.imsdk.model.body.IMTextBody;
import com.xdja.imsdk.model.body.IMVideoBody;
import com.xdja.imsdk.model.body.IMVoiceBody;
import com.xdja.imsdk.model.file.IMHDThumbFileInfo;
import com.xdja.imsdk.model.file.IMRawFileInfo;
import javax.inject.Inject;

public class DataMapper {
    private UserCache userCache;

    @Inject
    public DataMapper(UserCache userCache) {
        this.userCache = userCache;
    }

    public TalkSessionBean mapTalkSessionBean(IMSession session) {
        TalkSessionBean talkSessionBean = new TalkSessionBean();
        talkSessionBean.setTalkerAccount(session.getImPartner());
        talkSessionBean.setLastTime(session.getDisplayTime());
        talkSessionBean.setNotReadCount(session.getRemindCount());
        talkSessionBean.setTalkFlag(session.getSessionTag());
        talkSessionBean.setTalkType(ValueConverter.sessionTypeConvert(session.getSessionType()));
        IMMessage message = session.getLastMessage();
        if (message != null) {
            TalkMessageBean msg = this.mapTalkMessageBean(message);
            talkSessionBean.setLastMsg(msg);
            talkSessionBean.setLastMsgAccount(msg.getFrom());
            talkSessionBean.setLastMsgType(msg.getMessageType());
            talkSessionBean.setContent(msg.getContent());
        }
        return talkSessionBean;
    }

    public TalkMessageBean mapTalkMessageBean(IMMessage imMessage) {
        TalkMessageBean talkMessageBean = new TalkMessageBean();
        talkMessageBean.setId(imMessage.getIMMessageId());
        talkMessageBean.setFrom(imMessage.getFrom());
        talkMessageBean.setSenderCardId(imMessage.getCardId());
        talkMessageBean.setTo(imMessage.getTo());
        talkMessageBean.setMessageType(ValueConverter.imMsgTypeConvert(imMessage));
        talkMessageBean.setBomb(imMessage.isBombIMMessage());
        talkMessageBean.setGroupMsg(imMessage.isGroupIMMessage());
        talkMessageBean.setMessageState(ValueConverter.imMsgStateConvert(imMessage.getState()));
        talkMessageBean.setLimitTime(imMessage.getTimeToLive());
        talkMessageBean.setMine(this.userCache.isMine(imMessage.getFrom()));
        talkMessageBean.setShowTime(imMessage.getIMMessageTime());
        talkMessageBean.setFailCode(imMessage.getFailCode());
        if (imMessage.isRecalled()) {
            IMRecallBody recallBody = (IMRecallBody)imMessage.getMessageBody();
            talkMessageBean.setMessageType(101);
            talkMessageBean.setContent(recallBody.getNotice());
            return talkMessageBean;
        }
        if (imMessage.isTextIMMessage()) {
            if (imMessage.getType() == 65541 || imMessage.getType() == 65537) {
                talkMessageBean.setMessageType(102);
            }
            IMTextBody textBody = (IMTextBody)imMessage.getMessageBody();
            talkMessageBean.setContent(textBody.getContent());
            return talkMessageBean;
        }
        if (imMessage.isFileIMMessage()) {
            talkMessageBean.setFileInfo(this.mapFileInfo(imMessage));
        }
        if (imMessage.isCustom()) {
            IMTextBody textBody = (IMTextBody)imMessage.getMessageBody();
            talkMessageBean.setContent(textBody.getContent());
            talkMessageBean.setMessageType(102);
            return talkMessageBean;
        }
        return talkMessageBean;
    }

    public IMMessage mapIMMessage(TalkMessageBean talkMessageBean) {
        if (talkMessageBean == null) {
            return null;
        }
        IMMessage imMessage = new IMMessage();
        imMessage.setIMMessageId(talkMessageBean.getId());
        imMessage.setFrom(talkMessageBean.getFrom());
        imMessage.setCardId(talkMessageBean.getSenderCardId());
        imMessage.setTo(talkMessageBean.getTo());
        imMessage.setFailCode(talkMessageBean.getFailCode());
        imMessage.setType(ValueConverter.talkMsgTypeConvert(talkMessageBean));
        imMessage.setIMMessageTime(talkMessageBean.getShowTime());
        imMessage.setTimeToLive(talkMessageBean.getLimitTime());
        imMessage.setMessageBody(this.mapBody(talkMessageBean, imMessage.isFileIMMessage()));
        imMessage.setState(ValueConverter.talkMsgStateConvert(talkMessageBean.getMessageState()));
        return imMessage;
    }

    public IMFileInfo mapIMFileInfo(FileInfo fileInfo) {
        IMFileInfo imFileInfo = new IMFileInfo();
        IMMessage message = new IMMessage();
        message.setIMMessageId(fileInfo.getTalkMessageId());
        if (fileInfo instanceof ImageFileInfo) {
            ImageFileInfo imageFileInfo = (ImageFileInfo)fileInfo;
            imageFileInfo.getFileType();
            if (imageFileInfo.getType() == 2) {
                imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_HD);
            } else if (imageFileInfo.getType() == 3) {
                imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_RAW);
            } else {
                imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_SHOW);
            }
        } else if (fileInfo instanceof VideoFileInfo) {
            VideoFileInfo videoFileInfo = (VideoFileInfo)fileInfo;
            if (videoFileInfo.getType() == 3) {
                imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_RAW);
            } else {
                imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_SHOW);
            }
        } else {
            imFileInfo.setFileType(ImSdkFileConstant.FileType.IS_SHOW);
        }
        imFileInfo.setMessage(message);
        return imFileInfo;
    }

    public IMFileBody mapFileBody(FileInfo fileInfo) {
        IMVoiceBody fileBody = null;
        if (fileInfo instanceof VoiceFileInfo) {
            VoiceFileInfo voiceFileInfo = (VoiceFileInfo)fileInfo;
            fileBody = new IMVoiceBody(1, voiceFileInfo.getAmountOfTime());
        } else if (fileInfo instanceof ImageFileInfo) {
            FileInfo rawFileInfo;
            ImageFileInfo imageFileInfo = (ImageFileInfo)fileInfo;
            IMImageBody imageBody = new IMImageBody(3);
            FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
            if (hdFileInfo != null) {
                imageBody.setHdTFileInfo(this.mapIMHDThumbFileInfo(hdFileInfo));
            }
            if ((rawFileInfo = imageFileInfo.getRawFileInfo()) != null) {
                imageBody.setRawFileInfo(this.mapIMRawFileInfo(rawFileInfo));
            }
            fileBody = imageBody;
        } else if (fileInfo instanceof VideoFileInfo) {
            VideoFileInfo videoFileInfo = (VideoFileInfo)fileInfo;
            FileInfo rawFileInfo = videoFileInfo.getRawFileInfo();
            if (rawFileInfo != null) {
                IMVideoBody videoBody = new IMVideoBody(2, videoFileInfo.getAmountOfTime(), rawFileInfo.getFileSize());
                videoBody.setRawFileInfo(this.mapIMRawFileInfo(rawFileInfo));
                fileBody = videoBody;
            }
        } else {
            fileBody = new IMFileBody(0);
        }
        fileBody.setLocalPath(fileInfo.getFilePath());
        fileBody.setFileSize(fileInfo.getFileSize());
        fileBody.setTranslateSize(fileInfo.getTranslateSize());
        fileBody.setDisplayName(fileInfo.getFileName());
        fileBody.setSuffix(fileInfo.getSuffix());
        return fileBody;
    }

    private FileInfo mapFileInfo(IMMessage message) {
        IMMessageBody body = message.getMessageBody();
        FileInfo fileInfo = body instanceof IMVoiceBody ? this.mapVoiceFileInfo(body) : (body instanceof IMImageBody ? this.mapImageFileInfo(body) : (body instanceof IMVideoBody ? this.mapVideoFileInfo(body) : (body instanceof IMNormalFileBody ? this.mapNormalFileInfo(body) : new FileInfo())));
        IMFileBody fileBody = (IMFileBody)body;
        fileInfo.setFileState(this.mapFileState(fileBody.getState()));
        fileInfo.setTranslateSize(fileBody.getTranslateSize());
        fileInfo.setFileName(fileBody.getDisplayName());
        fileInfo.setFileSize(fileBody.getFileSize());
        fileInfo.setFilePath(fileBody.getLocalPath());
        fileInfo.setSuffix(fileBody.getSuffix());
        fileInfo.setTalkMessageId(message.getIMMessageId());
        return fileInfo;
    }

    public FileInfo mapFileInfo(IMFileInfo imFileInfo) {
        IMMessage message = imFileInfo.getMessage();
        if (message.isRecalled()) {
            LogUtil.d("message is already recall.");
            return null;
        }
        FileInfo fileInfo = this.mapFileInfo(message);
        fileInfo.setFileProperty(this.mapFileProperty(imFileInfo.getFileType()));
        return fileInfo;
    }

    public int mapFileProperty(ImSdkFileConstant.FileType fileType) {
        int type = 1;
        if (fileType == ImSdkFileConstant.FileType.IS_SHOW) {
            type = 1;
        } else if (fileType == ImSdkFileConstant.FileType.IS_HD) {
            type = 2;
        } else if (fileType == ImSdkFileConstant.FileType.IS_RAW) {
            type = 3;
        }
        return type;
    }

    private int mapFileState(ImSdkFileConstant.FileState state) {
        int result = 1;
        if (state == ImSdkFileConstant.FileState.DONE) {
            result = 2;
        } else if (state == ImSdkFileConstant.FileState.FAIL) {
            result = 5;
        } else if (state == ImSdkFileConstant.FileState.INACTIVE) {
            result = 1;
        } else if (state == ImSdkFileConstant.FileState.LOADING) {
            result = 3;
        } else if (state == ImSdkFileConstant.FileState.PAUSE) {
            result = 4;
        }
        return result;
    }

    private VoiceFileInfo mapVoiceFileInfo(IMMessageBody fileBody) {
        IMVoiceBody voiceBody = (IMVoiceBody)fileBody;
        VoiceFileInfo fileInfo = new VoiceFileInfo();
        fileInfo.setFileType(1);
        fileInfo.setAmountOfTime(voiceBody.getDuration());
        return fileInfo;
    }

    private ImageFileInfo mapImageFileInfo(IMMessageBody fileBody) {
        IMImageBody imageBody = (IMImageBody)fileBody;
        ImageFileInfo fileInfo = new ImageFileInfo();
        fileInfo.setFileType(3);
        IMHDThumbFileInfo hd = imageBody.getHdTFileInfo();
        IMRawFileInfo raw2 = imageBody.getRawFileInfo();
        if (hd != null) {
            FileInfo hdFileInfo = new FileInfo();
            hdFileInfo.setFileName(hd.getHdTDisplayName());
            hdFileInfo.setFilePath(hd.getHdTLocalPath());
            hdFileInfo.setFileSize(hd.getHdTFileSize());
            hdFileInfo.setTranslateSize(hd.getHdTFileTranslateSize());
            hdFileInfo.setFileState(this.mapFileState(hd.getHdState()));
            fileInfo.setHdFileInfo(hdFileInfo);
        }
        if (raw2 != null) {
            fileInfo.setOriginal(true);
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(raw2.getRawDisplayName());
            rawFileInfo.setFilePath(raw2.getRawLocalPath());
            rawFileInfo.setFileSize(raw2.getRawFileSize());
            rawFileInfo.setTranslateSize(raw2.getRawFileTranslateSize());
            rawFileInfo.setFileState(this.mapFileState(raw2.getRawState()));
            fileInfo.setRawFileInfo(rawFileInfo);
        }
        return fileInfo;
    }

    private VideoFileInfo mapVideoFileInfo(IMMessageBody fileBody) {
        IMVideoBody videoBody = (IMVideoBody)fileBody;
        VideoFileInfo fileInfo = new VideoFileInfo();
        fileInfo.setFileType(2);
        fileInfo.setAmountOfTime(videoBody.getDuration());
        fileInfo.setRawFileSize(videoBody.getSize());
        IMRawFileInfo raw2 = videoBody.getRawFileInfo();
        if (raw2 != null) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(raw2.getRawDisplayName());
            rawFileInfo.setFilePath(raw2.getRawLocalPath());
            rawFileInfo.setFileSize(raw2.getRawFileSize());
            rawFileInfo.setTranslateSize(raw2.getRawFileTranslateSize());
            rawFileInfo.setFileState(this.mapFileState(raw2.getRawState()));
            fileInfo.setRawFileInfo(rawFileInfo);
        }
        return fileInfo;
    }

    private NormalFileInfo mapNormalFileInfo(IMMessageBody fileBody) {
        IMNormalFileBody normalFileBody = (IMNormalFileBody)fileBody;
        NormalFileInfo fileInfo = new NormalFileInfo();
        fileInfo.setFileType(11);
        fileInfo.setNormalFileType(ValueConverter.imNormalFileTypeConvert((IMFileBody)normalFileBody));
        return fileInfo;
    }

    private IMHDThumbFileInfo mapIMHDThumbFileInfo(FileInfo fileInfo) {
        IMHDThumbFileInfo hdThumbFileInfo = new IMHDThumbFileInfo();
        hdThumbFileInfo.setHdTDisplayName(fileInfo.getFileName());
        hdThumbFileInfo.setHdTLocalPath(fileInfo.getFilePath());
        hdThumbFileInfo.setHdTFileSize(fileInfo.getFileSize());
        hdThumbFileInfo.setHdTFileTranslateSize(fileInfo.getTranslateSize());
        return hdThumbFileInfo;
    }

    private IMRawFileInfo mapIMRawFileInfo(FileInfo fileInfo) {
        IMRawFileInfo rawFileInfo = new IMRawFileInfo();
        rawFileInfo.setRawDisplayName(fileInfo.getFileName());
        rawFileInfo.setRawLocalPath(fileInfo.getFilePath());
        rawFileInfo.setRawFileSize(fileInfo.getFileSize());
        rawFileInfo.setRawFileTranslateSize(fileInfo.getTranslateSize());
        return rawFileInfo;
    }

    private IMMessageBody mapBody(TalkMessageBean talkMessageBean, boolean isFile) {
        if (!isFile) {
            return new IMTextBody(talkMessageBean.getContent());
        }
        if (talkMessageBean.getFileInfo() == null) {
            return new IMFileBody(100);
        }
        return this.mapFileBody(talkMessageBean.getFileInfo());
    }
}

